/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class VHflashQfunc
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(VHflashQfunc.class);
    double Vspec = 0.0;
    double Hspec = 0.0;
    Flash tpFlash;

    public VHflashQfunc(SystemInterface system, double Vspec, double Hspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Vspec = Vspec;
        this.Hspec = Hspec;
    }

    public double calcdQdPP() {
        double dQdVV = (this.system.getVolume() - this.Vspec) / (8.3144621 * this.system.getTemperature()) + this.system.getPressure() * this.system.getdVdPtn() / (8.3144621 * this.system.getTemperature());
        return dQdVV;
    }

    public double calcdQdTT() {
        double dQdTT = -this.system.getCp() / (this.system.getTemperature() * 8.3144621) - this.calcdQdT() / this.system.getTemperature();
        return dQdTT;
    }

    public double calcdQdT() {
        double dQdT = (this.Hspec - this.system.getEnthalpy()) / (this.system.getTemperature() * 8.3144621);
        return dQdT;
    }

    public double calcdQdP() {
        double dQdP = this.system.getPressure() * (this.system.getVolume() - this.Vspec) / (8.3144621 * this.system.getTemperature());
        return dQdP;
    }

    public double solveQ() {
        double oldPres = this.system.getPressure();
        double nyPres = this.system.getPressure();
        double nyTemp = this.system.getTemperature();
        double oldTemp = this.system.getTemperature();
        double iterations = 1.0;
        do {
            oldPres = nyPres;
            oldTemp = nyTemp;
            this.system.init(3);
            nyPres = oldPres - (iterations += 1.0) / (iterations + 10.0) * this.calcdQdP() / this.calcdQdPP();
            nyTemp = oldTemp - iterations / (iterations + 10.0) * this.calcdQdT() / this.calcdQdTT();
            this.system.setPressure(nyPres);
            this.system.setTemperature(nyTemp);
            this.tpFlash.run();
        } while (Math.abs((nyPres - oldPres) / nyPres) + Math.abs((nyTemp - oldTemp) / nyTemp) > 1.0E-9 && iterations < 1000.0);
        return nyPres;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(328.15, 50.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 31.0);
        testSystem.addComponent("ethane", 4.0);
        testSystem.addComponent("n-heptane", 0.2);
        testSystem.init(0);
        try {
            testOps.TPflash();
            testSystem.display();
            double energy = testSystem.getEnthalpy() * 1.1;
            double volume = testSystem.getVolume() * 0.9;
            testOps.VHflash(volume, energy);
            testSystem.display();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

