/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.jfree.chart.JFreeChart;

public class CricondenBarTemp1
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix dx;
    Matrix xcoef;

    public CricondenBarTemp1(SystemInterface system) {
        this.system = system;
        this.neq = this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(this.neq + 2, this.neq + 2);
        this.fvec = new Matrix(this.neq + 2, 1);
        this.u = new Matrix(this.neq + 2, 1);
        this.Xgij = new Matrix(this.neq + 2, 4);
        this.setu();
        this.uold = this.u.copy();
    }

    public void setfvec() {
        double xtot = 0.0;
        double dQdT = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            xtot += this.system.getPhase(1).getComponent(i).getx();
            dQdT -= this.system.getPhase(1).getComponent(i).getx() * (this.system.getPhase(0).getComponent(i).getdfugdt() - this.system.getPhase(1).getComponent(i).getdfugdt());
            this.fvec.set(i, 0, Math.log(this.system.getPhase(0).getComponent(i).getFugacityCoefficient() * this.system.getPhase(0).getComponent(i).getz() * this.system.getPressure()) - Math.log(this.system.getPhases()[1].getComponent(i).getFugacityCoefficient() * this.system.getPhases()[1].getComponent(i).getx() * this.system.getPressure()));
        }
        this.fvec.set(this.numberOfComponents, 0, 1.0 - xtot);
        this.fvec.set(this.numberOfComponents + 1, 0, dQdT);
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = 1.0 / this.system.getBeta() * (dij / this.system.getPhases()[0].getComponent(i).getx() - 1.0 + this.system.getPhases()[0].getComponent(i).getdfugdx(j)) + 1.0 / (1.0 - this.system.getBeta()) * (dij / this.system.getPhases()[1].getComponent(i).getx() - 1.0 + this.system.getPhases()[1].getComponent(i).getdfugdx(j));
                this.Jac.set(i, j, tempJ);
            }
        }
    }

    public void setu() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.u.set(i, 0, this.system.getBeta() * this.system.getPhases()[0].getComponent(i).getx());
        }
    }

    public void init() {
        int i;
        double temp = 0.0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            temp += this.u.get(i, 0);
        }
        this.system.setBeta(temp);
        for (i = 0; i < this.numberOfComponents; ++i) {
            this.system.getPhases()[0].getComponent(i).setx(this.u.get(i, 0) / this.system.getBeta());
            this.system.getPhases()[1].getComponent(i).setx((this.system.getPhases()[0].getComponent(i).getz() - this.u.get(i, 0)) / (1.0 - this.system.getBeta()));
            this.system.getPhases()[0].getComponent(i).setK(this.system.getPhases()[0].getComponent(i).getx() / this.system.getPhases()[1].getComponent(i).getx());
            this.system.getPhases()[1].getComponent(i).setK(this.system.getPhases()[0].getComponent(i).getK());
        }
        this.system.init(3);
    }

    public double solve() {
        ++this.iter;
        this.init();
        this.setfvec();
        this.setJac();
        this.dx = this.Jac.solve(this.fvec);
        this.dx.print(10, 10);
        this.u.minusEquals(this.dx);
        return this.dx.norm2() / this.u.norm2();
    }

    public void run() {
        this.solve();
    }

    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    public double[] get(String name) {
        return new double[0];
    }

    public void printToFile(String name) {
    }

    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    public double[][] getPoints(int i) {
        return null;
    }

    public String[][] getResultTable() {
        return null;
    }

    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

