/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;

public class DewPointTemperatureFlashDer
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;

    public DewPointTemperatureFlashDer(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int i;
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && this.system.getPressure() > this.system.getPhase(0).getComponent(0).getPC()) {
            this.setSuperCritical(true);
        }
        this.system.init(0);
        this.system.setBeta(0, 0.999999999999999);
        this.system.setBeta(1, 1.0E-15);
        this.system.init(1);
        this.system.setNumberOfPhases(2);
        double oldTemp = 0.0;
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
            this.system.getChemicalReactionOperations().solveChemEq(1);
        }
        for (int i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
            this.system.getPhases()[0].getComponent(i2).setx(this.system.getPhases()[0].getComponent(i2).getz());
            if (this.system.getPhases()[0].getComponent(i2).getIonicCharge() != 0.0) {
                this.system.getPhases()[0].getComponent(i2).setx(1.0E-40);
                continue;
            }
            if (this.system.getPhases()[1].getComponent(i2).getName().equals("water")) {
                this.system.getPhases()[1].getComponent(i2).setx(1.0);
                continue;
            }
            if (this.system.getPhases()[1].hasComponent("water")) {
                this.system.getPhases()[1].getComponent(i2).setx(1.0E-10);
                continue;
            }
            this.system.getPhases()[1].getComponent(i2).setx(1.0 / this.system.getPhases()[0].getComponent(i2).getK() * this.system.getPhases()[1].getComponent(i2).getz());
        }
        double xtotal = 0.0;
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            xtotal += this.system.getPhases()[1].getComponent(i).getx();
        }
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[1].getComponent(i).setx(this.system.getPhases()[1].getComponent(i).getx() / xtotal);
        }
        int iterations = 0;
        int maxNumberOfIterations = 1000;
        double ktot = 0.0;
        do {
            int i3;
            oldTemp = this.system.getTemperature();
            ++iterations;
            this.system.init(2);
            xtotal = 0.0;
            double dfdT = 0.0;
            for (int i4 = 0; i4 < this.system.getPhases()[1].getNumberOfComponents(); ++i4) {
                xtotal += 1.0 / this.system.getPhases()[0].getComponent(i4).getK() * this.system.getPhases()[1].getComponent(i4).getz();
                dfdT -= 1.0 / this.system.getPhases()[0].getComponent(i4).getK() * this.system.getPhases()[1].getComponent(i4).getz() * (this.system.getPhases()[1].getComponent(i4).getdfugdt() - this.system.getPhases()[0].getComponent(i4).getdfugdt());
            }
            double f = xtotal - 1.0;
            if (iterations < 5) {
                this.system.setTemperature(this.system.getTemperature() + (double)iterations / ((double)iterations + 100.0) * (xtotal * this.system.getTemperature() - this.system.getTemperature()));
            } else {
                this.system.setTemperature(this.system.getTemperature() - (double)iterations / (10.0 + (double)iterations) * f / dfdT);
            }
            this.system.init(1);
            ktot = 0.0;
            for (i3 = 0; i3 < this.system.getPhases()[1].getNumberOfComponents(); ++i3) {
                if (this.system.getPhase(0).getComponent(i3).getIonicCharge() != 0.0 || this.system.getPhase(0).getComponent(i3).isIsIon()) {
                    this.system.getPhases()[0].getComponent(i3).setK(1.0E-40);
                } else {
                    this.system.getPhases()[0].getComponent(i3).setK(Math.exp(this.system.getPhases()[1].getComponent(i3).getLogFugacityCoefficient() - this.system.getPhases()[0].getComponent(i3).getLogFugacityCoefficient()));
                }
                this.system.getPhases()[1].getComponent(i3).setK(this.system.getPhases()[0].getComponent(i3).getK());
                this.system.getPhases()[1].getComponent(i3).setx(1.0 / this.system.getPhases()[0].getComponent(i3).getK() * this.system.getPhases()[1].getComponent(i3).getz());
                ktot += Math.abs(this.system.getPhases()[1].getComponent(i3).getK() - 1.0);
            }
            xtotal = 0.0;
            for (i3 = 0; i3 < this.system.getPhases()[1].getNumberOfComponents(); ++i3) {
                xtotal += this.system.getPhases()[1].getComponent(i3).getx();
            }
            for (i3 = 0; i3 < this.system.getPhases()[1].getNumberOfComponents(); ++i3) {
                this.system.getPhases()[1].getComponent(i3).setx(this.system.getPhases()[1].getComponent(i3).getx() / xtotal);
            }
        } while (Math.abs(xtotal - 1.0) > 1.0E-6 || Math.abs(oldTemp - this.system.getTemperature()) / oldTemp > 1.0E-4 || iterations < 3 && iterations < maxNumberOfIterations);
        if (Math.abs(xtotal - 1.0) > 1.0E-5 || ktot < 0.001 && this.system.getPhase(0).getNumberOfComponents() > 1) {
            this.setSuperCritical(true);
        }
        if (ktot < 0.001) {
            if (this.system.getTemperature() < 90.0) {
                this.setSuperCritical(true);
            } else {
                this.setSuperCritical(false);
            }
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

