/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.datapresentation.jfreechart.Graph2b;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FugTestConstP
extends ConstantDutyTemperatureFlash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FugTestConstP.class);
    public double temp = 0.0;
    public double pres = 0.0;
    public SystemInterface testSystem;
    public SystemInterface testSystem2;
    public ThermodynamicOperations testOps;
    public ThermodynamicOperations testOps2;
    public int compNumber = 0;
    public String compName;
    public boolean compNameGiven = false;

    public FugTestConstP(SystemInterface system) {
        this.testSystem = system;
        this.testOps = new ThermodynamicOperations(this.testSystem);
        this.pres = this.testSystem.getPressure();
    }

    public FugTestConstP(SystemInterface system, double pres) {
        this.testSystem = system;
        this.testOps = new ThermodynamicOperations(this.testSystem);
        this.pres = pres;
    }

    public void initTestSystem2(int K) {
        this.testSystem2 = new SystemSrkSchwartzentruberEos(this.temp, this.pres);
        this.testSystem2.addComponent(this.compName, 1.0);
        this.testSystem2.setPhaseType(0, PhaseType.GAS);
        this.testOps2 = new ThermodynamicOperations(this.testSystem2);
    }

    @Override
    public void run() {
        double SolidFug = 0.0;
        double Pvapsolid = 0.0;
        double SolVapFugCoeff = 0.0;
        double solvol = 0.0;
        double soldens = 0.0;
        double trpTemp = 0.0;
        boolean CCequation = true;
        double[][] Fug = new double[4][20];
        double[][] Fugrel = new double[2][20];
        for (int k = 0; k < this.testSystem.getPhases()[0].getNumberOfComponents(); ++k) {
            if (!this.testSystem.getPhase(0).getComponent(k).doSolidCheck()) continue;
            this.compName = this.testSystem.getPhase(0).getComponent(k).getComponentName();
            trpTemp = this.testSystem.getPhases()[0].getComponent(k).getTriplePointTemperature();
            this.initTestSystem2(k);
            if (Math.abs(this.testSystem.getPhases()[0].getComponent(k).getHsub()) < 1.0E-6) {
                CCequation = false;
            }
            for (int i = 0; i < 20; ++i) {
                logger.info("--- calculating --- " + this.compName + " at ");
                this.temp = trpTemp + 2.0 - (double)i * trpTemp / 40.0;
                this.testSystem.setTemperature(this.temp);
                this.testSystem2.setTemperature(this.temp);
                logger.info("temperature " + this.temp);
                if (this.temp > trpTemp + 0.1) {
                    this.temp = trpTemp;
                }
                if (CCequation) {
                    Pvapsolid = this.testSystem.getPhase(0).getComponent(k).getCCsolidVaporPressure(this.temp);
                    logger.info("pvap solid CC " + Pvapsolid);
                } else {
                    Pvapsolid = this.testSystem.getPhase(0).getComponent(k).getSolidVaporPressure(this.temp);
                    logger.info("pvap solid Antonie " + Pvapsolid);
                }
                soldens = this.testSystem.getPhase(0).getComponent(k).getPureComponentSolidDensity(this.temp) * 1000.0;
                if (soldens > 2000.0) {
                    soldens = 1000.0;
                }
                logger.info("Solid_vapour_____solid density" + soldens);
                solvol = 1.0 / soldens * this.testSystem.getPhase(0).getComponent(k).getMolarMass();
                SolidFug = Pvapsolid * Math.exp(solvol / (8.3144621 * this.temp) * (this.pres - Pvapsolid));
                this.testSystem2.setPressure(Pvapsolid);
                this.testOps.TPflash();
                this.testOps2.TPflash();
                SolVapFugCoeff = this.testSystem2.getPhase(0).getComponent(0).getFugacityCoefficient();
                Fug[3][i] = this.testSystem.getPhase(0).getFugacity(k);
                Fug[1][i] = SolidFug * SolVapFugCoeff;
                Fug[0][i] = this.testSystem.getTemperature();
                Fug[2][i] = this.testSystem.getTemperature();
                Fugrel[0][i] = this.testSystem.getTemperature();
                Fugrel[1][i] = Fug[1][i] / Fug[3][i];
            }
            String[] title = new String[]{"Solid Fugacity", "Fluid Fugacity"};
            Graph2b graffug = new Graph2b(Fug, title, this.compName + " Fugacity  VS T, constant P= " + this.pres, "Temperature [K]", "Fugacity [bar]");
            graffug.setVisible(true);
            String[] title2 = new String[]{"Solid/Fluid"};
            Graph2b grafvapor = new Graph2b(Fugrel, title2, this.compName + " Fugacity Ratio", "Temperature [K]", "Fsolid/Ffluid");
            grafvapor.setVisible(true);
        }
    }

    public void PrintToFile(String FileName) {
    }
}

