/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;

public class HydrateEquilibriumLine
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    double[][] hydratePoints = null;
    double minPressure = 1.0;
    double maxPressure = 200.0;
    int numberOfPoints = 10;

    public HydrateEquilibriumLine(SystemInterface system, double minPres, double maxPres) {
        super(system);
        this.minPressure = minPres;
        this.maxPressure = maxPres;
    }

    @Override
    public void run() {
        SystemInterface system = this.system.clone();
        this.hydratePoints = new double[2][this.numberOfPoints];
        system.setHydrateCheck(true);
        ThermodynamicOperations ops = new ThermodynamicOperations(system);
        system.setPressure(this.minPressure);
        double dp = (this.maxPressure - this.minPressure) / ((double)this.numberOfPoints - 1.0);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            system.setPressure(this.minPressure + dp * (double)i);
            try {
                ops.hydrateFormationTemperature();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hydratePoints[0][i] = system.getTemperature();
            this.hydratePoints[1][i] = system.getPressure();
        }
    }

    @Override
    public double[][] getPoints(int i) {
        return this.hydratePoints;
    }
}

