/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolidComplexTemperatureCalc
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SolidComplexTemperatureCalc.class);
    String comp1;
    String comp2;
    public static double Kcomplex = 0.1337360218155205;
    public static double HrefComplex = 4598.717135;
    public static double TrefComplex = 244.19;

    public SolidComplexTemperatureCalc(SystemInterface system) {
        super(system);
    }

    public SolidComplexTemperatureCalc(SystemInterface system, String comp1, String comp2) {
        this(system);
        this.comp1 = comp1;
        this.comp2 = comp2;
        if (comp1.equals("MEG") && comp2.equals("water")) {
            Kcomplex = 0.168048;
            HrefComplex = 14450.0;
            TrefComplex = 223.95;
        }
        if (comp1.equals("TEG") && comp2.equals("water")) {
            Kcomplex = 0.14804730995177287;
            HrefComplex = 6629.1366952637;
            TrefComplex = 244.19;
        }
        if (comp1.equals("methanol") && comp2.equals("water")) {
            Kcomplex = 0.208059;
            HrefComplex = 8540.0;
            TrefComplex = 171.25;
        }
    }

    public void runOld() {
        int i;
        double sumx = 0.0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iter = 0;
        double funkOld = 0.0;
        double deltaT = 1.0;
        double[] Ksolid = new double[this.system.getPhase(0).getNumberOfComponents()];
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            Ksolid[i] = 1.0;
        }
        do {
            ++iter;
            ops.TPflash();
            for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (this.system.getPhases()[5].getComponent(i).getName().equals("water") || this.system.getPhases()[5].getComponent(i).getName().equals("MEG")) {
                    this.system.getPhases()[5].getComponent(i).setx(0.5);
                    continue;
                }
                this.system.getPhases()[5].getComponent(i).setx(1.0E-20);
            }
            logger.info("Temperaure  " + this.system.getTemperature() + " sumx " + sumx);
            sumx = 0.0;
            for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                Ksolid[i] = this.system.getPhase(0).getComponent(i).getFugacityCoefficient() / this.system.getPhases()[5].getComponent(i).fugcoef(this.system.getPhases()[5]);
                sumx += Ksolid[i] * this.system.getPhase(0).getComponent(i).getx();
            }
            double funk = sumx - 1.0;
            double dfunkdt = (funk - funkOld) / deltaT;
            funkOld = funk;
            double dT = -funk / dfunkdt;
            double oldTemp = this.system.getTemperature();
            if (iter > 1) {
                this.system.setTemperature(this.system.getTemperature() + dT * (double)iter * 1.0 / (5.0 + (double)iter));
            } else {
                this.system.setTemperature(this.system.getTemperature() + 0.01);
            }
            deltaT = this.system.getTemperature() - oldTemp;
            logger.info("Temperaure  " + this.system.getTemperature() + " sumx " + sumx);
        } while (Math.abs(sumx - 1.0) > 1.0E-8);
        logger.info("sumx " + sumx);
        this.system.setNumberOfPhases(this.system.getNumberOfPhases() + 1);
        this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 5);
        this.system.setBeta(this.system.getNumberOfPhases() - 1, 1.0E-10);
        this.system.init(3);
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        double deltaT = 1.0;
        int compNumber_1 = this.system.getPhase(0).getComponent(this.comp1).getComponentNumber();
        int compNumber_2 = this.system.getPhase(0).getComponent(this.comp2).getComponentNumber();
        double temperature = 0.0;
        double oldTemperature = 0.0;
        double oldError = 0.0;
        double error = 0.0;
        boolean testFalse = true;
        int iteration = 0;
        do {
            ++iteration;
            temperature = this.system.getTemperature();
            ops.TPflash();
            double complexActivity = this.system.getPhaseOfType("aqueous").getActivityCoefficient(compNumber_1) * this.system.getPhaseOfType("aqueous").getComponent(compNumber_1).getx() * this.system.getPhaseOfType("aqueous").getActivityCoefficient(compNumber_2) * this.system.getPhaseOfType("aqueous").getComponent(compNumber_2).getx();
            if (complexActivity < 1.0E-5) {
                complexActivity = 1.0E-5;
            }
            double rightSide = 8.3144621 * Math.log(complexActivity);
            double leftSide = 8.3144621 * Math.log(Kcomplex) + HrefComplex * (1.0 / TrefComplex - 1.0 / this.system.getTemperature());
            error = rightSide - leftSide;
            double dErrordT = (error - oldError) / (temperature - oldTemperature);
            deltaT = iteration >= 2 && testFalse ? -error / dErrordT : rightSide - leftSide;
            if (Math.abs(deltaT) > 10.0) {
                testFalse = !testFalse;
                deltaT = Math.signum(deltaT) * 10.0;
            } else {
                testFalse = true;
            }
            oldTemperature = temperature;
            oldError = error;
            this.system.setTemperature(this.system.getTemperature() + deltaT);
        } while (Math.abs(deltaT) > 0.001 && iteration < 50);
    }

    @Override
    public void printToFile(String name) {
    }

    public double getKcomplex() {
        return Kcomplex;
    }

    public void setKcomplex(double Kcomplex) {
        SolidComplexTemperatureCalc.Kcomplex = Kcomplex;
    }

    public double getHrefComplex() {
        return HrefComplex;
    }

    public void setHrefComplex(double HrefComplex) {
        SolidComplexTemperatureCalc.HrefComplex = HrefComplex;
    }

    public double getTrefComplex() {
        return TrefComplex;
    }

    public void setTrefComplex(double TrefComplex) {
        SolidComplexTemperatureCalc.TrefComplex = TrefComplex;
    }
}

