/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaterDewPointTemperatureMultiphaseFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaterDewPointTemperatureMultiphaseFlash.class);

    public WaterDewPointTemperatureMultiphaseFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        ThermodynamicOperations TPflashOps = new ThermodynamicOperations(this.system);
        this.system.setMultiPhaseCheck(true);
        double dT = 0.1;
        this.system.setTemperature(600.0);
        do {
            ++this.i;
            TPflashOps.TPflash();
            if (this.system.hasPhaseType("aqueous")) {
                dT = this.system.getPhaseOfType("aqueous").getComponent("water").getNumberOfMolesInPhase() / this.system.getPhase(0).getComponent("water").getNumberOfmoles();
                if (dT > 1.0) {
                    dT = 1.0;
                }
                this.system.setTemperature(this.system.getTemperature() + dT);
                continue;
            }
            dT = -10.0;
            this.system.setTemperature(this.system.getTemperature() + dT);
        } while (this.i < 350 && Math.abs(dT) > 1.0E-5);
        logger.info("i " + this.i);
    }

    @Override
    public void printToFile(String name) {
    }
}

