/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.propertygenerator;

import Jama.Matrix;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.BaseOperation;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLGApropertyTableGeneratorWater
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(OLGApropertyTableGeneratorWater.class);
    BicubicInterpolator interpolationFunc = new BicubicInterpolator();
    SystemInterface thermoSystem = null;
    SystemInterface gasSystem = null;
    SystemInterface oilSystem = null;
    SystemInterface waterSystem = null;
    ThermodynamicOperations thermoOps = null;
    double[] pressures;
    double[] temperatureLOG;
    double[] temperatures;
    double[] pressureLOG = null;
    double[] bubP;
    double[] bubT;
    double[] dewP;
    double[] bubPLOG;
    double[] dewPLOG;
    Matrix XMatrixgas;
    Matrix XMatrixoil;
    Matrix XMatrixwater;
    double[][] ROG = null;
    double TC;
    double PC;
    double RSWTOB;
    double[][][] props;
    int nProps;
    String[] names;
    Matrix[] xcoef = new Matrix[9];
    String[] units;
    int temperatureSteps;
    int pressureSteps;
    boolean continuousDerivativesExtrapolation = true;
    boolean hasGasValues = false;
    boolean hasOilValues = false;
    boolean hasWaterValues = false;
    boolean[][][] hasValue;
    Matrix aMatrix = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    String fileName = "c:/Appl/OLGAneqsim.tab";

    public OLGApropertyTableGeneratorWater(SystemInterface system) {
        this.thermoSystem = system;
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.XMatrixgas = new Matrix(9, 4);
        this.XMatrixoil = new Matrix(9, 4);
        this.XMatrixwater = new Matrix(9, 4);
        this.gasSystem = new SystemSrkEos(298.0, 10.0);
        this.gasSystem.addComponent("methane", 1.0);
        this.gasSystem.init(0);
        this.gasSystem.setNumberOfPhases(1);
        this.waterSystem = new SystemSrkCPAstatoil(298.0, 10.0);
        this.waterSystem.addComponent("water", 1.0);
        this.waterSystem.init(0);
        this.waterSystem.setNumberOfPhases(1);
        this.oilSystem = new SystemSrkEos(298.0, 10.0);
        this.oilSystem.addComponent("nC10", 1.0);
        this.oilSystem.init(0);
        this.oilSystem.setNumberOfPhases(1);
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void setPressureRange(double minPressure, double maxPressure, int numberOfSteps) {
        this.pressures = new double[numberOfSteps];
        this.pressureLOG = new double[numberOfSteps];
        double step = (maxPressure - minPressure) / ((double)numberOfSteps * 1.0 - 1.0);
        for (int i = 0; i < numberOfSteps; ++i) {
            this.pressures[i] = minPressure + (double)i * step;
            this.pressureLOG[i] = this.pressures[i] * 100000.0;
        }
    }

    public void setTemperatureRange(double minTemperature, double maxTemperature, int numberOfSteps) {
        this.temperatures = new double[numberOfSteps];
        this.temperatureLOG = new double[numberOfSteps];
        double step = (maxTemperature - minTemperature) / ((double)numberOfSteps * 1.0 - 1.0);
        for (int i = 0; i < numberOfSteps; ++i) {
            this.temperatures[i] = minTemperature + (double)i * step;
            this.temperatureLOG[i] = this.temperatures[i] - 273.15;
        }
    }

    public void calcPhaseEnvelope() {
        try {
            this.thermoOps.calcPTphaseEnvelope();
            this.TC = this.thermoSystem.getTC() - 273.15;
            this.PC = this.thermoSystem.getPC() * 100000.0;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public double[] calcBubP(double[] temperatures) {
        double[] bubP = new double[temperatures.length];
        this.bubPLOG = new double[temperatures.length];
        for (int i = 0; i < temperatures.length; ++i) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.bubblePointPressureFlash(false);
                bubP[i] = this.thermoSystem.getPressure();
                this.bubPLOG[i] = bubP[i] * 100000.0;
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                bubP[i] = 0.0;
            }
        }
        return bubP;
    }

    public double[] calcDewP(double[] temperatures) {
        double[] dewP = new double[temperatures.length];
        this.dewPLOG = new double[temperatures.length];
        for (int i = 0; i < temperatures.length; ++i) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.dewPointPressureFlashHC();
                dewP[i] = this.thermoSystem.getPressure();
                this.dewPLOG[i] = dewP[i] * 100000.0;
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                dewP[i] = 0.0;
            }
        }
        return dewP;
    }

    public double[] calcBubT(double[] pressures) {
        double[] bubTemps = new double[pressures.length];
        for (int i = 0; i < pressures.length; ++i) {
            this.thermoSystem.setPressure(pressures[i]);
            try {
                this.thermoOps.bubblePointTemperatureFlash();
                this.bubT[i] = this.thermoSystem.getPressure();
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.bubT[i] = 0.0;
            }
        }
        return bubTemps;
    }

    public void initCalc() {
        double stdTemp = 288.15;
        double stdPres = 1.01325;
        double[] molfracs = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        double[] MW = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        double[] dens = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        String[] components = new String[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < molfracs.length; ++i) {
            molfracs[i] = this.thermoSystem.getPhase(0).getComponent(i).getz();
            components[i] = this.thermoSystem.getPhase(0).getComponent(i).getComponentName();
            MW[i] = this.thermoSystem.getPhase(0).getComponent(i).getMolarMass() * 1000.0;
            dens[i] = this.thermoSystem.getPhase(0).getComponent(i).getNormalLiquidDensity();
        }
        this.thermoSystem.setTemperature(stdTemp);
        this.thermoSystem.setPressure(stdPres);
        this.thermoOps.TPflash();
    }

    public void calcRSWTOB() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.RSWTOB = this.thermoSystem.getPhase(0).hasComponent("water") ? this.thermoSystem.getPhase(0).getComponent("water").getNumberOfmoles() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / (this.thermoSystem.getTotalNumberOfMoles() * this.thermoSystem.getMolarMass()) : 0.0;
    }

    @Override
    public void run() {
        this.calcRSWTOB();
        logger.info("RSWTOB " + this.RSWTOB);
        this.nProps = 29;
        this.props = new double[this.nProps][this.pressures.length][this.temperatures.length];
        this.units = new String[this.nProps];
        this.names = new String[this.nProps];
        boolean acceptedFlash = true;
        for (int j = 0; j < this.temperatures.length; ++j) {
            this.thermoSystem.setTemperature(this.temperatures[j]);
            for (int i = 0; i < this.pressures.length; ++i) {
                int phaseNumb;
                this.thermoSystem.setPressure(this.pressures[i]);
                try {
                    logger.info("TPflash... " + this.thermoSystem.getTemperature() + " pressure " + this.thermoSystem.getPressure());
                    if (this.thermoSystem.getTemperature() > 379.95) {
                        logger.info("here I am");
                        this.thermoOps.TPflash();
                    } else {
                        this.thermoOps.TPflash();
                    }
                    this.thermoSystem.init(3);
                    this.thermoSystem.initPhysicalProperties();
                    acceptedFlash = true;
                }
                catch (Exception ex) {
                    acceptedFlash = false;
                    logger.info("fail temperature " + this.thermoSystem.getTemperature() + " fail pressure " + this.thermoSystem.getPressure());
                    this.thermoSystem.display();
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                int k = 0;
                if (this.thermoSystem.hasPhaseType("gas") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("gas");
                    this.props[k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "GAS DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOG/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOG/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.hasPhaseType("oil") ? this.thermoSystem.getPhase(phaseNumb).getBeta() * this.thermoSystem.getPhase(phaseNumb).getMolarMass() / (this.thermoSystem.getPhase(phaseNumb).getBeta() * this.thermoSystem.getPhase(phaseNumb).getMolarMass() + this.thermoSystem.getPhase("oil").getBeta() * this.thermoSystem.getPhase("oil").getMolarMass()) : 1.0;
                    this.names[k] = "GAS MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "GAS VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "GAS THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS ENTROPY";
                    this.units[k] = "J/KG/K";
                    ++k;
                    this.hasGasValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasGasValues) {
                    do {
                        if (i > 1) {
                            this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                        }
                        if (!this.names[k].equals("GAS MASS FRACTION") || !(this.props[k][i][j] < 0.0)) continue;
                        this.props[k][i][j] = 0.0;
                    } while (++k < 9);
                } else {
                    this.gasSystem.setTemperature(this.temperatures[j]);
                    this.gasSystem.setPressure(this.pressures[i]);
                    this.gasSystem.init(3);
                    this.gasSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "GAS DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOG/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOG/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = 0.0;
                    this.names[k] = "GAS MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "GAS VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getCp() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getEnthalpy() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "GAS THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getEntropy() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS ENTROPY";
                    this.units[k] = "J/KG/K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("oil") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("oil");
                    this.props[k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "LIQUID DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOL/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOL/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "LIQUID VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "LIQUID THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                    this.hasOilValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasOilValues) {
                    do {
                        if (i <= 1) continue;
                        this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                    } while (++k < 17);
                } else {
                    this.oilSystem.setPhaseType(0, PhaseType.LIQUID);
                    this.oilSystem.setTemperature(this.temperatures[j]);
                    this.oilSystem.setPressure(this.pressures[i]);
                    this.oilSystem.init(3);
                    this.oilSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "LIQUID DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOL/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOL/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "LIQUID VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getCp() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getEnthalpy() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getEntropy() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "LIQUID THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("aqueous");
                    this.props[k][i][j] = this.thermoSystem.getPhase(0).getComponent("water").getx() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / this.thermoSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER VAPOR MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "WATER DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOWAT/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOWAT/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "WATER VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "WATER THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                    this.hasWaterValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasWaterValues) {
                    do {
                        if (j <= 1) continue;
                        this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                    } while (++k < 26);
                } else {
                    this.waterSystem.setTemperature(this.temperatures[j]);
                    this.waterSystem.setPressure(this.pressures[i]);
                    this.waterSystem.setPhaseType(0, PhaseType.LIQUID);
                    this.waterSystem.init(3);
                    this.waterSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.thermoSystem.getPhase(0).hasComponent("water") ? this.thermoSystem.getPhase(0).getComponent("water").getz() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / this.thermoSystem.getPhase(0).getMolarMass() : 0.0;
                    this.names[k] = "WATER VAPOR MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "WATER DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOWAT/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOWAT/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "WATER VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getCp() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getEnthalpy() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getEntropy() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "WATER THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("oil") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("gas"), this.thermoSystem.getPhaseNumberOfPhase("oil"));
                    this.names[k] = "VAPOR-LIQUID SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                } else if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                    this.props[k][i][j] = i < 2 ? this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) : (j < 2 ? this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]) : this.props[k][i - 1][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]));
                    this.props[k][i][j] = 0.01;
                    ++k;
                } else {
                    this.props[k][i][j] = 0.01;
                    this.names[k] = "VAPOR-LIQUID SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("gas"), this.thermoSystem.getPhaseNumberOfPhase("aqueous"));
                    this.names[k] = "VAPOR-WATER SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                } else if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                    this.props[k][i][j] = i < 2 ? this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) : (j < 2 ? this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]) : this.props[k][i - 1][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]));
                    this.props[k][i][j] = 0.06;
                    ++k;
                } else {
                    this.props[k][i][j] = 0.06;
                    this.names[k] = "VAPOR-WATER SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("oil") && this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("oil"), this.thermoSystem.getPhaseNumberOfPhase("aqueous"));
                    this.names[k] = "LIQUID-WATER SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                    continue;
                }
                if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                    this.props[k][i][j] = i < 2 ? this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) : (j < 2 ? this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]) : this.props[k][i - 1][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]) + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]));
                    this.props[k][i][j] = 0.02;
                    ++k;
                    continue;
                }
                this.props[k][i][j] = 0.02;
                this.names[k] = "LIQUID-WATER SURFACE TENSION";
                this.units[k] = "N/M";
                ++k;
            }
        }
        logger.info("Finished TPflash...");
        if (this.thermoSystem.getPhase(0).hasComponent("water")) {
            this.thermoSystem.removeComponent("water");
        }
        this.bubP = this.calcBubP(this.temperatures);
        this.dewP = this.calcDewP(this.temperatures);
        logger.info("Finished creating arrays");
        BicubicInterpolatingFunction funcGasDens = this.interpolationFunc.interpolate(this.pressures, this.temperatures, this.props[0]);
        logger.info("interpolated value " + funcGasDens.value(40.0, 298.0));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        logger.info("TC " + this.TC + " PC " + this.PC);
        for (int i = 0; i < this.pressures.length; ++i) {
            this.thermoSystem.setPressure(this.pressures[i]);
            for (int j = 0; j < this.temperatures.length; ++j) {
                logger.info("pressure " + this.pressureLOG[i] + " temperature " + this.temperatureLOG[j]);
            }
        }
        this.writeOLGAinpFile(this.fileName);
    }

    public void writeOLGAinpFile2(String filename) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), "utf-8"));){
            writer.write("'WATER-OPTION ENTROPY NONEQ '\n");
            writer.write(this.pressures.length + "   " + this.temperatures.length + "    " + this.RSWTOB + "\n");
            int Pcounter = 0;
            for (int i = 0; i < this.pressures.length; ++i) {
                if (Pcounter > 4) {
                    writer.write("\n");
                    Pcounter = 0;
                }
                writer.write(this.pressureLOG[i] + "    ");
                ++Pcounter;
            }
            writer.write("\n");
            int Tcounter = 0;
            for (int i = 0; i < this.temperatures.length; ++i) {
                if (Tcounter > 4) {
                    writer.write("\n");
                    Tcounter = 0;
                }
                writer.write(this.temperatureLOG[i] + "    ");
                ++Tcounter;
            }
            writer.write("\n");
            int bubPcounter = 0;
            for (int i = 0; i < this.temperatures.length; ++i) {
                if (bubPcounter > 4) {
                    writer.write("\n");
                    bubPcounter = 0;
                }
                writer.write(this.bubPLOG[i] + "    ");
                ++bubPcounter;
            }
            writer.write("\n");
            int dewPcounter = 0;
            for (int i = 0; i < this.temperatures.length; ++i) {
                if (dewPcounter > 4) {
                    writer.write("\n");
                    dewPcounter = 0;
                }
                writer.write(this.dewPLOG[i] + "    ");
                ++dewPcounter;
            }
            writer.write("\n");
            for (int k = 0; k < this.nProps; ++k) {
                if (this.names[k] == null) continue;
                logger.info("Writing variable: " + this.names[k]);
                writer.write(this.names[k] + " (" + this.units[k] + ")\n");
                for (int i = 0; i < this.pressures.length; ++i) {
                    int counter = 0;
                    for (int j = 0; j < this.temperatures.length; ++j) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(this.props[k][i][j] + "    ");
                        ++counter;
                    }
                    writer.write("\n");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeOLGAinpFile(String filename) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"));){
            int j;
            int counter;
            int i;
            writer.write("'WATER-OPTION ENTROPY NONEQ '\n");
            writer.write(this.pressures.length + "   " + this.temperatures.length + "    " + this.RSWTOB + "\n");
            int Pcounter = 0;
            for (int i2 = 0; i2 < this.pressures.length; ++i2) {
                if (Pcounter > 4) {
                    writer.write("\n");
                    Pcounter = 0;
                }
                writer.write(this.pressureLOG[i2] + "    ");
                ++Pcounter;
            }
            writer.write("\n");
            int Tcounter = 0;
            for (int i3 = 0; i3 < this.temperatures.length; ++i3) {
                if (Tcounter > 4) {
                    writer.write("\n");
                    Tcounter = 0;
                }
                writer.write(this.temperatureLOG[i3] + "    ");
                ++Tcounter;
            }
            writer.write("\n");
            int bubPcounter = 0;
            for (int i4 = 0; i4 < this.temperatures.length; ++i4) {
                if (bubPcounter > 4) {
                    writer.write("\n");
                    bubPcounter = 0;
                }
                writer.write(this.bubPLOG[i4] + "    ");
                ++bubPcounter;
            }
            writer.write("\n");
            int dewPcounter = 0;
            for (i = 0; i < this.temperatures.length; ++i) {
                if (dewPcounter > 4) {
                    writer.write("\n");
                    dewPcounter = 0;
                }
                writer.write(this.dewPLOG[i] + "    ");
                ++dewPcounter;
            }
            writer.write("\n");
            writer.write("GAS DENSITY (KG/M3)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[0][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID DENSITY (KG/M3)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[9][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER DENSITY (KG/M3)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[18][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOG/DP (S2/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[1][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOL/DP (S2/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[10][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOWAT/DP (S2/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[19][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOG/DT (KG/M3-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[2][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOL/DT (KG/M3-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[11][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("DRHOWAT/DT (KG/M3-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[20][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS MASS FRACTION (-)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[3][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER VAPOR MASS FRACTION (-)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[17][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS VISCOSITY (NS/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[4][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID VISCOSITY (NS/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[12][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER VISCOSITY (NS/M2)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[21][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS HEAT CAPACITY (J/KG-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[5][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID HEAT CAPACITY (J/KG-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[13][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER HEAT CAPACITY (J/KG-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[22][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS ENTHALPY (J/KG)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[6][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID ENTHALPY (J/KG)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[14][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER ENTHALPY (J/KG)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[23][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS THERMAL CONDUCTIVITY (W/M-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[7][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID THERMAL CONDUCTIVITY (W/M-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[16][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER THERMAL CONDUCTIVITY (W/M-K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[25][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("VAPOR-LIQUID SURFACE TENSION (N/M)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[26][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("VAPOR-WATER SURFACE TENSION (N/M)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[27][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID-WATER SURFACE TENSION (N/M)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[28][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("GAS ENTROPY (J/KG/K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[8][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("LIQUID ENTROPY (J/KG/K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[15][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
            writer.write("WATER ENTROPY (J/KG/K)\n");
            for (i = 0; i < this.pressures.length; ++i) {
                counter = 0;
                for (j = 0; j < this.temperatures.length; ++j) {
                    if (counter > 4) {
                        writer.write("\n");
                        counter = 0;
                    }
                    writer.write(this.props[24][i][j] + "    ");
                    ++counter;
                }
                writer.write("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void extrapolateTable() {
        for (int j = 0; j < this.temperatures.length; ++j) {
            for (int i = 0; i < this.pressures.length; ++i) {
                if (this.hasValue[26][i][j]) continue;
            }
        }
    }
}

