/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util;

import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class NeqSimLogging {
    private static final Logger logger = LogManager.getLogger("neqsim");

    public static void setGlobalLogging(String level) {
        LoggerContext context = (LoggerContext)LogManager.getContext(false);
        Configuration config = context.getConfiguration();
        Level logLevel = NeqSimLogging.stringToLevel(level);
        LoggerConfig rootLoggerConfig = config.getRootLogger();
        rootLoggerConfig.setLevel(logLevel);
        config.getLoggers().forEach((name, loggerConfig) -> {
            if (name.startsWith("neqsim")) {
                loggerConfig.setLevel(logLevel);
            }
        });
        context.updateLoggers();
    }

    private static Level stringToLevel(String level) {
        try {
            return Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid logging level: {}. Defaulting to INFO.", (Object)level);
            return Level.INFO;
        }
    }

    public static void resetAllLoggers() {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext(false);
            URL resource = NeqSimLogging.class.getClassLoader().getResource("log4j2.properties");
            if (resource == null) {
                logger.error("Resource 'log4j2.properties' not found. Unable to reset loggers.");
                return;
            }
            context.setConfigLocation(resource.toURI());
            context.reconfigure();
        }
        catch (Exception e) {
            logger.error("Failed to reset loggers: {}", (Object)e.getMessage());
        }
    }
}

