/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.BaseUnit;

public class PowerUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;

    public PowerUnit(double value, String unit) {
        super(value, unit);
    }

    public double getConversionFactor(String name) {
        switch (name) {
            case "W": {
                return 1.0;
            }
            case "kW": {
                return 1000.0;
            }
            case "MW": {
                return 1000000.0;
            }
            case "hp": {
                return 745.699872;
            }
            case "BTU/hr": {
                return 0.29307107;
            }
        }
        throw new RuntimeException(new InvalidInputException(this, "getConversionFactor", name, "unit not supported"));
    }

    @Override
    public double getValue(double val, String fromunit, String tounit) {
        this.invalue = val;
        return this.getConversionFactor(fromunit) / this.getConversionFactor(tounit) * this.invalue;
    }

    @Override
    public double getValue(String tounit) {
        return this.getConversionFactor(this.inunit) / this.getConversionFactor(tounit) * this.invalue;
    }
}

