# Generated by Django 2.2.4 on 2019-08-19 22:24

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.documents.blocks
import wagtail.embeds.blocks
import wagtail.images.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailimages', '0001_squashed_0021'),
        ('wagtailcore', '0041_group_collection_permissions_verbose_name_plural'),
    ]

    operations = [
        migrations.CreateModel(
            name='PersonPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('custom_titles', models.CharField(blank=True, help_text='Some custom titles, separated by commas', max_length=250, verbose_name='Custom titles')),
                ('abstract', wagtail.core.fields.RichTextField(blank=True, verbose_name='Abstract')),
                ('extra_infos', wagtail.core.fields.StreamField([('heading', wagtail.core.blocks.StructBlock([('header_level', wagtail.core.blocks.ChoiceBlock(choices=[('h1', 'H1'), ('h2', 'H2'), ('h3', 'H3'), ('h4', 'H4'), ('h5', 'H5'), ('h6', 'H6')], label='Header level')), ('text', wagtail.core.blocks.CharBlock(label='Text'))])), ('link', wagtail.core.blocks.StructBlock([('description', wagtail.core.blocks.CharBlock(label='Description')), ('url', wagtail.core.blocks.URLBlock(label='URL', validators=[django.core.validators.URLValidator(['http', 'https', 'ftp', 'ftps', 'mailto', 'xmpp', 'tel'])]))])), ('paragraph', wagtail.core.blocks.RichTextBlock()), ('quote', wagtail.core.blocks.BlockQuoteBlock()), ('image', wagtail.images.blocks.ImageChooserBlock()), ('document', wagtail.documents.blocks.DocumentChooserBlock()), ('embed', wagtail.embeds.blocks.EmbedBlock())], blank=True, verbose_name='Extra informations')),
                ('picture', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Picture')),
            ],
            options={
                'verbose_name': 'Person',
                'verbose_name_plural': 'Persons',
                'ordering': ['name'],
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='PersonTitle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
            ],
            options={
                'verbose_name': 'Person title',
                'verbose_name_plural': 'Person titles',
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='PersonPageTitle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='titles', to='wagtailperson.PersonPage')),
                ('title', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailperson.PersonTitle')),
            ],
            options={
                'verbose_name': 'Person Page Title',
                'verbose_name_plural': 'Person Page Titles',
            },
        ),
    ]
