# Generated by Django 2.2.4 on 2020-02-20 18:54

from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import taggit.managers
import wagtail.core.fields


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0003_taggeditem_add_unique_index'),
        ('wagtailimages', '0001_squashed_0021'),
        ('wagtailperson', '0004_auto_20190821_2153'),
    ]

    operations = [
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('intro', models.CharField(blank=True, help_text='Shown on the short descriptions', max_length=250, verbose_name='Introduction')),
                ('abstract', wagtail.core.fields.RichTextField(blank=True, verbose_name='Abstract')),
                ('picture', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Picture')),
            ],
            options={
                'verbose_name': 'Person or author',
                'verbose_name_plural': 'Persons or authors',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PersonExtrernalLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('label', models.CharField(max_length=255, verbose_name='Label')),
                ('url', models.URLField(max_length=255, verbose_name='URL')),
                ('person', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='external_links', to='wagtailperson.Person', verbose_name='Person')),
            ],
            options={
                'verbose_name': "Person's extrernal link",
                'verbose_name_plural': "Person's extrernal links",
            },
        ),
        migrations.CreateModel(
            name='PersonTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', modelcluster.fields.ParentalKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='wagtailperson.Person')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wagtailperson_persontag_items', to='taggit.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.DeleteModel(
            name='PersonTitle',
        ),
        migrations.AlterModelOptions(
            name='personindexpage',
            options={'verbose_name': 'Persons or authors Index Page', 'verbose_name_plural': 'Persons or authors Index Pages'},
        ),
        migrations.AlterModelOptions(
            name='personpage',
            options={'ordering': ['title'], 'verbose_name': 'Person or author page', 'verbose_name_plural': 'Person or author pagess'},
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='abstract',
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='custom_titles',
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='extra_infos',
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='intro',
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='name',
        ),
        migrations.RemoveField(
            model_name='personpage',
            name='picture',
        ),
        migrations.DeleteModel(
            name='PersonTitlePage',
        ),
        migrations.AddField(
            model_name='person',
            name='tags',
            field=taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='wagtailperson.PersonTag', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='personpage',
            name='person',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='wagtailperson.Person', verbose_name='Person'),
        ),
    ]
