import io
import pyzipper  # type: ignore
import click
from rich.status import Status

from malwarebazaar.api import Bazaar
from malwarebazaar.config import Config


@click.command(help="Downloads a file by its hash.")
@click.option("-u", "--unzip", is_flag=True, help="Unzips the sample.")
@click.option(
    "-o",
    "--output",
    type=click.Path(writable=True, dir_okay=False),
    help="Write downloaded file to this path.",
)
@click.argument("sha256_hash")
def download(unzip, output, sha256_hash: str):
    b = Bazaar(Config.get_instance()["api_key"])
    with Status(f"Downloading {sha256_hash}..."):
        data = b.download_file(sha256_hash)
        if unzip:
            with pyzipper.AESZipFile(io.BytesIO(data)) as zf:
                zf.setpassword("infected".encode("ascii"))
                zipinfo = zf.infolist()[0]
                data = zf.read(zipinfo.filename)

    if output:
        filepath = output
    elif unzip:
        filepath = zipinfo.filename
    else:
        filepath = sha256_hash + ".zip"

    with io.open(filepath, "wb") as handle:
        handle.write(data)
