import click
from malwarebazaar.config import Config
from rich.console import Console


@click.command(help="Initializes bazaar cli.")
@click.argument("API_KEY", type=str)
def init(api_key: str):
    c = Console()
    success = Config.init_config(api_key)
    if success:
        c.print("Successfully set API-Key!")
