import click
from rich.console import Console
from rich.status import Status

from malwarebazaar.api import Bazaar
from malwarebazaar.config import Config
from malwarebazaar.output import csv_output
from malwarebazaar.sample import Sample


@click.command(help="Get information about recently submitted samples. The API allows either the last 100 samples or "
                    "samples uploaded in the last 60 minutes. As the amount is quite big, the default output type is "
                    "csv.")
@click.option("-n", "--number", is_flag=True,
              help="Queries for the last 100 samples instead of samples uploaded in the last hour.")
def recent(number: bool):
    ec = Console(stderr=True, style="bold red")
    bazaar = Bazaar(Config.get_instance()["api_key"])
    with Status(f"Querying MalwareBazaar..."):
        if number:
            res = bazaar.query_recent("100")
        else:
            res = bazaar.query_recent("time")

    if res["query_status"] != "ok":
        ec.print(f"Invalid Bazaar response: {res['query_status']}")
        exit(-1)

    samples = [Sample(**sample) for sample in res["data"]]
    csv_output(samples)
