from typing import List

from rich.console import Console

from malwarebazaar.config import Config
from malwarebazaar.sample import Sample


def single_sample(s: Sample, console: Console = Console()):
    console.print(f"Filename:\t{s.file_name}")
    console.print(f"MD5:\t\t{s.md5_hash}")
    console.print(f"SHA1:\t\t{s.sha1_hash}")
    console.print(f"SHA256:\t\t{s.sha256_hash}")
    console.print(f"Imphash:\t{s.imphash}")
    console.print(f"Signature:\t{s.signature}")
    console.print(f"Tags:\t\t{', '.join(s.tags or [])}")


def multiple_samples(samples: List[Sample], console: Console = Console()):
    for sample in samples:
        single_sample(sample, console)
        console.print()


def csv_output(samples: List[Sample], console: Console = Console()):
    soft_wrap = console.soft_wrap
    console.soft_wrap = True
    columns = Config.get_instance()["csv_columns"]
    console.print("\"", end="")
    console.print("\",\"".join(columns.keys()), end="")
    console.print("\"")
    for idx, sample in enumerate(samples):
        cols = []
        for key in columns.values():
            col = sample.get(key, "None")
            if not col:
                col = "None"
            elif isinstance(col, list):
                col = ",".join(col)
            col = f"\"{col}\""
            cols.append(col)
        console.print(",".join(cols))
    console.soft_wrap = soft_wrap
