# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['malwarebazaar', 'malwarebazaar.commands']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'pyzipper>=0.3.6,<0.4.0', 'requests>=2.28.1,<3.0.0']

entry_points = \
{'console_scripts': ['bazaar = malwarebazaar.bazaar:cli']}

setup_kwargs = {
    'name': 'malwarebazaar',
    'version': '0.1.5a0',
    'description': 'CLI wrapper for malware bazaar API (bazaar.abuse.ch)',
    'long_description': '# (Malware)Bazaar\n**A [MalwareBazaar](https://bazaar.abuse.ch) API wrapper and CLI**\n\n## Installation\nIf you want to use the API only:\n\n```\npip install malwarebazaar\n```\n\nIf you want to use the CLI:\n\n```\npip install malwarebazaar[cli]\n```\n\n_Note: Previous versions also included pre-built binaries, however, I stopped adding them. Please just use a local python environment instead._\n\n## Usage\n### Python\n```python\nfrom malwarebazaar.api import Bazaar\n\nbazaar = Bazaar("myapikey")\nresponse = bazaar.query_hash("Hash to search for.")\nfile = bazaar.download_file("Sha256 hash for file to donwload.")\n```\n\n### CLI\n```commandline\n$ bazaar init myapikey\nSuccessfully set API-Key!\n$ bazaar query hash f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807\nFilename:       03891ab57eb301579005f62953dfd21e.exe\nMD5:            03891ab57eb301579005f62953dfd21e\nSHA1:           41efd56ea49b72c6dd53b5341f295e549b1b64a5\nSHA256:         f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807\nImphash:        f34d5f2d4577ed6d9ceec516c1f5a744\nSignature:      RedLineStealer\nTags:           exe, RedLineStealer\n$ bazaar download f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807\n$ file f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.zip \nf670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.zip: Zip archive data, at least v5.1 to extract\n$ bazaar download f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807 --unzip\n$ file f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.exe \nf670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.exe: PE32 executable (GUI) Intel 80386 Mono/.Net assembly, for MS Windows\n```',
    'author': '3c7',
    'author_email': '3c7@posteo.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/3c7/bazaar',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
