import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as cdk from '@aws-cdk/core';
/**
 * The interface for all wordpress.
 */
export interface WordPressProps {
    /**
     * The WordPress VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The WordPress RDS
     */
    readonly rdsInstance?: rds.DatabaseInstance;
    /**
     * The WordPress cluster
     */
    readonly cluster?: ecs.Cluster;
}
export declare class WordPress extends cdk.Construct {
    readonly endpoint: string;
    constructor(scope: cdk.Construct, id: string, props?: WordPressProps);
}
