"""
Deprecated streaming functionality for backwards compatibility with v1 SDK.

This module provides the stream() function which wraps replicate.use() with streaming=True.
"""

from __future__ import annotations

import warnings
from typing import Any, Dict, Type, Union, Iterator, AsyncIterator, overload
from typing_extensions import deprecated

from .._client import Client, AsyncClient
from ._predictions_use import use

__all__ = ["stream"]


def _format_deprecation_message(ref: str, input: Dict[str, Any]) -> str:
    """Format the deprecation message with a working example."""
    # Format the input dict for display
    input_str = "{\n"
    for key, value in input.items():
        if isinstance(value, str):
            input_str += f'        "{key}": "{value}",\n'
        else:
            input_str += f'        "{key}": {value},\n'
    input_str += "    }"

    return (
        f"replicate.stream() is deprecated and will be removed in a future version. "
        f"Use replicate.use() with streaming=True instead:\n\n"
        f'    model = replicate.use("{ref}", streaming=True)\n'
        f"    for event in model(input={input_str}):\n"
        f'        print(str(event), end="")\n'
    )


@overload
def stream(
    client: Type[Client],
    ref: str,
    *,
    input: Dict[str, Any],
) -> Iterator[str]: ...


@overload
def stream(
    client: Type[AsyncClient],
    ref: str,
    *,
    input: Dict[str, Any],
) -> AsyncIterator[str]: ...


@deprecated("replicate.stream() is deprecated. Use replicate.use() with streaming=True instead")
def stream(
    client: Union[Type[Client], Type[AsyncClient]],
    ref: str,
    *,
    input: Dict[str, Any],
) -> Union[Iterator[str], AsyncIterator[str]]:
    """
    Run a model and stream its output (deprecated).

    This function is deprecated. Use replicate.use() with streaming=True instead:

        model = replicate.use("anthropic/claude-4.5-sonnet", streaming=True)
        for event in model(input={"prompt": "Hello"}):
            print(str(event), end="")

    Args:
        client: The Replicate client class (Client or AsyncClient)
        ref: Reference to the model to run. Can be a string with owner/name format
            (e.g., "anthropic/claude-4.5-sonnet") or owner/name:version format.
        input: Dictionary of input parameters for the model. The required keys depend
            on the specific model being run.

    Returns:
        An iterator (or async iterator) that yields output strings as they are
        generated by the model
    """
    # Log deprecation warning with helpful migration example
    warnings.warn(
        _format_deprecation_message(ref, input),
        DeprecationWarning,
        stacklevel=2,
    )

    # Use the existing use() function with streaming=True
    model = use(client, ref, streaming=True)  # type: ignore[var-annotated]  # pyright: ignore[reportUnknownVariableType]

    # Call the model with the input
    return model(**input)  # type: ignore[return-value]
