# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List
from typing_extensions import Literal, Required, Annotated, TypedDict

from ..._utils import PropertyInfo

__all__ = ["PredictionCreateParams"]


class PredictionCreateParams(TypedDict, total=False):
    deployment_owner: Required[str]

    deployment_name: Required[str]

    input: Required[object]
    """The model's input as a JSON object.

    The input schema depends on what model you are running. To see the available
    inputs, click the "API" tab on the model you are running or
    [get the model version](#models.versions.get) and look at its `openapi_schema`
    property. For example,
    [stability-ai/sdxl](https://replicate.com/stability-ai/sdxl) takes `prompt` as
    an input.

    Files should be passed as HTTP URLs or data URLs.

    Use an HTTP URL when:

    - you have a large file > 256kb
    - you want to be able to use the file multiple times
    - you want your prediction metadata to be associable with your input files

    Use a data URL when:

    - you have a small file <= 256kb
    - you don't want to upload and host the file somewhere
    - you don't need to use the file again (Replicate will not store it)
    """

    stream: bool
    """**This field is deprecated.**

    Request a URL to receive streaming output using
    [server-sent events (SSE)](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events).

    This field is no longer needed as the returned prediction will always have a
    `stream` entry in its `urls` property if the model supports streaming.
    """

    webhook: str
    """An HTTPS URL for receiving a webhook when the prediction has new output.

    The webhook will be a POST request where the request body is the same as the
    response body of the [get prediction](#predictions.get) operation. If there are
    network problems, we will retry the webhook a few times, so make sure it can be
    safely called more than once. Replicate will not follow redirects when sending
    webhook requests to your service, so be sure to specify a URL that will resolve
    without redirecting.
    """

    webhook_events_filter: List[Literal["start", "output", "logs", "completed"]]
    """
    By default, we will send requests to your webhook URL whenever there are new
    outputs or the prediction has finished. You can change which events trigger
    webhook requests by specifying `webhook_events_filter` in the prediction
    request:

    - `start`: immediately on prediction start
    - `output`: each time a prediction generates an output (note that predictions
      can generate multiple outputs)
    - `logs`: each time log output is generated by a prediction
    - `completed`: when the prediction reaches a terminal state
      (succeeded/canceled/failed)

    For example, if you only wanted requests to be sent at the start and end of the
    prediction, you would provide:

    ```json
    {
      "input": {
        "text": "Alice"
      },
      "webhook": "https://example.com/my-webhook",
      "webhook_events_filter": ["start", "completed"]
    }
    ```

    Requests for event types `output` and `logs` will be sent at most once every
    500ms. If you request `start` and `completed` webhooks, then they'll always be
    sent regardless of throttling.
    """

    cancel_after: Annotated[str, PropertyInfo(alias="Cancel-After")]

    prefer: Annotated[str, PropertyInfo(alias="Prefer")]
