# Framework Development Guide

```{raw} latex
\chapter*{Preface}
\addcontentsline{toc}{chapter}{Preface}
```

```{note}
This section of the manual contains technical details not required for understanding and operating Constellations, but
only for implementing Constellation libraries in different languages, or for consulting the available APIs
```

```{raw} latex
\part{General}
```

```{toctree}
:caption: ⚙ General

contributing
flatpak
release
```

```{raw} latex
\part{Technical Documentation}
```

```{toctree}
:caption: 🔧 Technical Documentation

satellite
naming
protocols
```

```{raw} latex
\part{C++ Developer API}
```

```{toctree}
:caption: C++ Developer API
:maxdepth: 2

cxx/core/index
cxx/satellite/index
cxx/controller/index
cxx/listener/index
```

```{raw} latex
\part{Python Developer API}
```

```{toctree}
:caption: Python Developer API
:maxdepth: 3

python/core/core
```

```{raw} latex
\part{Appendix}
```

```{toctree}
:caption: Appendix
:maxdepth: 2

../protocols/index
```
