# The Constellation

This section of the manual provides an overview of the concepts and design principles of the Constellation framework.

Constellation is a network-distributed control and data acquisition framework geared towards flexibility and easy integration
of new sensors, detectors and other devices. The components of the framework run on a single computer or multiple machines
across a local IP-based network, and allow to distribute commands, record data and collect monitoring and logging information
from its different constituents.

## General Considerations

### Naming Things

In software, "naming things" is often among the most difficult tasks as names both need to be "speaking" (describe what they
refer to and what it does) and easy to remember (and type).

The name "Constellation" is borrowed from space flight, where satellite constellations operate with relatively large autonomy, transmitting
data between them, and communicating with a ground control center which issues commands and polices the entire system.
Consequently, vocabulary from space flight appears at different places in the framework and - hopefully - helps in clarifying
functionality and intention. Examples are 'satellite', 'payload', 'safe mode', or 'launch'.

Other vocabulary used throughout the framework and this manual originate from data acquisition systems in nuclear and particle
physics:

* A "run" designates a self-contained measurement or series of measurements. In Constellation, this corresponds to one transition of the
  finite state machine into the 'RUN' state and out of it.
* A "trigger" is an often hardware-based signal generated by a configurable logic from input measurements. It is used to rapidly
  decide whether to store a corresponding fraction of data or discard it. In particle physics a trigger signal could e.g. be generated
  from a coincidence of two devices measuring the passage of a particle.
* A notoriously difficult term is "event". In particle physics it is often used to describe the entirety of data belonging to a
  physical measurement such as the passage of a particle. Sometimes however it is also used when referring to the smallest portion
  of data produced by a given device.

### Limitations & Threat Model Considerations

In its current version, Constellation is intended to run in closed internal networks only, in the following referred to as
"subnets". It is assumed that

* the subnet and all connected hosts can be trusted.
* there are no malicious actors on the subnet.
* the transmitted information is non-confidential to any actor on the subset.
* the intervening router between neighboring subnets is configured to filter multicast packets, which is a standard
  configuration.

All Constellation communication is handled exclusively via [ephemeral ports as defined in RFC 6335](https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml),
which is why no privileged user account
is required for running a constellation host - unless the controlled hardware requires so. If in such a case the
Constellation host requires elevated privileges for running, this is clearly documented in the respective component
documentation.

It is possible to configure Constellation hosts to bind to specific network interfaces only, but the default configuration -
chosen for user convenience - is to bind to all available network interfaces of the host.

In general, users are required to satisfy their personal threat model by external means such as firewalls, physical isolation
and virtualization on the edges of the subnet Constellation runs on.

## Component Types

The Constellation framework knows three different types of components; Satellites, controllers and listeners. Each of them
have a different purpose and can or cannot partake in interactions. The components are described in the subsequent sections.

### The Satellite

Satellites are the main actors in a Constellation. They implement instrument controlling code as well as data receivers and
any other component that should follow the Constellation operation synchronously.

Satellites are stateful and are implemented around a well-defined finite state machine which governs their behavior and
possible actions. Satellites are partaking in all Constellation communication protocols: They react to commands from
controllers, listen to other satellites' heartbeat messages, distribute log messages and telemetry data and transmit their
recorded instrument data.

A detailed description of the satellite structure, its features and possibilities to interact with are provided in
[a dedicated chapter](./satellite.md) in this user guide.

### The Controller

Controllers are the main user interface to a Constellation. They represent the nodes which are capable of sending commands
to satellites via the control protocol. The main code for parsing and interpreting configuration
files resides in the controller, and graphical or command-line user interfaces typically are implemented as controllers.

Controllers do not possess a state, i.e. they are not a satellite of the Constellation. The main advantage of this approach
is that controllers can be closed and reopened by the operator, or can even crash, without affecting the Constellation.

The functionality of the controller in Constellation is described in detail in [this chapter](./controller.md).

### The Listener

The listener is the least powerful type of component. As the name suggests, this program only listens to protocol
communications of other components, typically via the monitoring protocol, and is entirely passive otherwise.
Consequently, listeners are stateless  and the Constellation is not affected by them appearing or disappearing during
operations.

A typical example would be a log message interface which subscribes to log streams for any satellite in the Constellation.

The two use cases for a listener, logging and telemetry, are described separately in the
[logging chapter](./logging.md) and [telemetry chapter](./telemetry.md).
