from ai_review.config import settings
from ai_review.libs.constants.vcs_provider import VCSProvider
from ai_review.services.vcs.gitlab.client import GitLabVCSClient
from ai_review.services.vcs.types import VCSClient


def get_vcs_client() -> VCSClient:
    match settings.vcs.provider:
        case VCSProvider.GITLAB:
            return GitLabVCSClient()
        case _:
            raise ValueError(f"Unsupported provider: {settings.llm.provider}")
