from ccxt.base.types import Entry


class ImplicitAPI:
    public_get_currency = publicGetCurrency = Entry('currency', 'public', 'GET', {'cost': 3})
    public_get_currency_currency = publicGetCurrencyCurrency = Entry('currency/{currency}', 'public', 'GET', {'cost': 3})
    public_get_symbol = publicGetSymbol = Entry('symbol', 'public', 'GET', {'cost': 3})
    public_get_symbol_symbol = publicGetSymbolSymbol = Entry('symbol/{symbol}', 'public', 'GET', {'cost': 3})
    public_get_ticker = publicGetTicker = Entry('ticker', 'public', 'GET', {'cost': 3})
    public_get_ticker_symbol = publicGetTickerSymbol = Entry('ticker/{symbol}', 'public', 'GET', {'cost': 3})
    public_get_trades = publicGetTrades = Entry('trades', 'public', 'GET', {'cost': 3})
    public_get_trades_symbol = publicGetTradesSymbol = Entry('trades/{symbol}', 'public', 'GET', {'cost': 3})
    public_get_orderbook = publicGetOrderbook = Entry('orderbook', 'public', 'GET', {'cost': 3})
    public_get_orderbook_symbol = publicGetOrderbookSymbol = Entry('orderbook/{symbol}', 'public', 'GET', {'cost': 3})
    public_get_candles = publicGetCandles = Entry('candles', 'public', 'GET', {'cost': 3})
    public_get_candles_symbol = publicGetCandlesSymbol = Entry('candles/{symbol}', 'public', 'GET', {'cost': 3})
    private_get_trading_balance = privateGetTradingBalance = Entry('trading/balance', 'private', 'GET', {'cost': 15.0015})
    private_get_order = privateGetOrder = Entry('order', 'private', 'GET', {'cost': 15.0015})
    private_get_order_clientorderid = privateGetOrderClientOrderId = Entry('order/{clientOrderId}', 'private', 'GET', {'cost': 15.0015})
    private_get_trading_fee_all = privateGetTradingFeeAll = Entry('trading/fee/all', 'private', 'GET', {'cost': 15.0015})
    private_get_trading_fee_symbol = privateGetTradingFeeSymbol = Entry('trading/fee/{symbol}', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_account = privateGetMarginAccount = Entry('margin/account', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_account_symbol = privateGetMarginAccountSymbol = Entry('margin/account/{symbol}', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_position = privateGetMarginPosition = Entry('margin/position', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_position_symbol = privateGetMarginPositionSymbol = Entry('margin/position/{symbol}', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_order = privateGetMarginOrder = Entry('margin/order', 'private', 'GET', {'cost': 15.0015})
    private_get_margin_order_clientorderid = privateGetMarginOrderClientOrderId = Entry('margin/order/{clientOrderId}', 'private', 'GET', {'cost': 15.0015})
    private_get_history_order = privateGetHistoryOrder = Entry('history/order', 'private', 'GET', {'cost': 15.0015})
    private_get_history_trades = privateGetHistoryTrades = Entry('history/trades', 'private', 'GET', {'cost': 15.0015})
    private_get_history_order_orderid_trades = privateGetHistoryOrderOrderIdTrades = Entry('history/order/{orderId}/trades', 'private', 'GET', {'cost': 15.0015})
    private_get_account_balance = privateGetAccountBalance = Entry('account/balance', 'private', 'GET', {'cost': 15.0015})
    private_get_account_crypto_address_currency = privateGetAccountCryptoAddressCurrency = Entry('account/crypto/address/{currency}', 'private', 'GET', {'cost': 15.0015})
    private_get_account_crypto_addresses_currency = privateGetAccountCryptoAddressesCurrency = Entry('account/crypto/addresses/{currency}', 'private', 'GET', {'cost': 15.0015})
    private_get_account_crypto_used_addresses_currency = privateGetAccountCryptoUsedAddressesCurrency = Entry('account/crypto/used-addresses/{currency}', 'private', 'GET', {'cost': 15.0015})
    private_get_account_crypto_estimate_withdraw = privateGetAccountCryptoEstimateWithdraw = Entry('account/crypto/estimate-withdraw', 'private', 'GET', {'cost': 15.0015})
    private_get_account_crypto_is_mine_address = privateGetAccountCryptoIsMineAddress = Entry('account/crypto/is-mine/{address}', 'private', 'GET', {'cost': 15.0015})
    private_get_account_transactions = privateGetAccountTransactions = Entry('account/transactions', 'private', 'GET', {'cost': 15.0015})
    private_get_account_transactions_id = privateGetAccountTransactionsId = Entry('account/transactions/{id}', 'private', 'GET', {'cost': 15.0015})
    private_get_sub_acc = privateGetSubAcc = Entry('sub-acc', 'private', 'GET', {'cost': 15.0015})
    private_get_sub_acc_acl = privateGetSubAccAcl = Entry('sub-acc/acl', 'private', 'GET', {'cost': 15.0015})
    private_get_sub_acc_balance_subaccountuserid = privateGetSubAccBalanceSubAccountUserID = Entry('sub-acc/balance/{subAccountUserID}', 'private', 'GET', {'cost': 15.0015})
    private_get_sub_acc_deposit_address_subaccountuserid_currency = privateGetSubAccDepositAddressSubAccountUserIdCurrency = Entry('sub-acc/deposit-address/{subAccountUserId}/{currency}', 'private', 'GET', {'cost': 15.0015})
    private_post_order = privatePostOrder = Entry('order', 'private', 'POST', {'cost': 1})
    private_post_margin_order = privatePostMarginOrder = Entry('margin/order', 'private', 'POST', {'cost': 1})
    private_post_account_crypto_address_currency = privatePostAccountCryptoAddressCurrency = Entry('account/crypto/address/{currency}', 'private', 'POST', {'cost': 1})
    private_post_account_crypto_withdraw = privatePostAccountCryptoWithdraw = Entry('account/crypto/withdraw', 'private', 'POST', {'cost': 1})
    private_post_account_crypto_transfer_convert = privatePostAccountCryptoTransferConvert = Entry('account/crypto/transfer-convert', 'private', 'POST', {'cost': 1})
    private_post_account_transfer = privatePostAccountTransfer = Entry('account/transfer', 'private', 'POST', {'cost': 1})
    private_post_account_transfer_internal = privatePostAccountTransferInternal = Entry('account/transfer/internal', 'private', 'POST', {'cost': 1})
    private_post_sub_acc_freeze = privatePostSubAccFreeze = Entry('sub-acc/freeze', 'private', 'POST', {'cost': 1})
    private_post_sub_acc_activate = privatePostSubAccActivate = Entry('sub-acc/activate', 'private', 'POST', {'cost': 1})
    private_post_sub_acc_transfer = privatePostSubAccTransfer = Entry('sub-acc/transfer', 'private', 'POST', {'cost': 1})
    private_put_order_clientorderid = privatePutOrderClientOrderId = Entry('order/{clientOrderId}', 'private', 'PUT', {'cost': 1})
    private_put_margin_account_symbol = privatePutMarginAccountSymbol = Entry('margin/account/{symbol}', 'private', 'PUT', {'cost': 1})
    private_put_margin_order_clientorderid = privatePutMarginOrderClientOrderId = Entry('margin/order/{clientOrderId}', 'private', 'PUT', {'cost': 1})
    private_put_account_crypto_withdraw_id = privatePutAccountCryptoWithdrawId = Entry('account/crypto/withdraw/{id}', 'private', 'PUT', {'cost': 1})
    private_put_sub_acc_acl_subaccountuserid = privatePutSubAccAclSubAccountUserId = Entry('sub-acc/acl/{subAccountUserId}', 'private', 'PUT', {'cost': 1})
    private_delete_order = privateDeleteOrder = Entry('order', 'private', 'DELETE', {'cost': 1})
    private_delete_order_clientorderid = privateDeleteOrderClientOrderId = Entry('order/{clientOrderId}', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_account = privateDeleteMarginAccount = Entry('margin/account', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_account_symbol = privateDeleteMarginAccountSymbol = Entry('margin/account/{symbol}', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_position = privateDeleteMarginPosition = Entry('margin/position', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_position_symbol = privateDeleteMarginPositionSymbol = Entry('margin/position/{symbol}', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_order = privateDeleteMarginOrder = Entry('margin/order', 'private', 'DELETE', {'cost': 1})
    private_delete_margin_order_clientorderid = privateDeleteMarginOrderClientOrderId = Entry('margin/order/{clientOrderId}', 'private', 'DELETE', {'cost': 1})
    private_delete_account_crypto_withdraw_id = privateDeleteAccountCryptoWithdrawId = Entry('account/crypto/withdraw/{id}', 'private', 'DELETE', {'cost': 1})
    private_patch_order_clientorderid = privatePatchOrderClientOrderId = Entry('order/{clientOrderId}', 'private', 'PATCH', {'cost': 1})
