from ccxt.base.types import Entry


class ImplicitAPI:
    public_get_market_tickers = publicGetMarketTickers = Entry('market/tickers', 'public', 'GET', {'cost': 1})
    public_get_market_ticker = publicGetMarketTicker = Entry('market/ticker', 'public', 'GET', {'cost': 1})
    public_get_market_index_tickers = publicGetMarketIndexTickers = Entry('market/index-tickers', 'public', 'GET', {'cost': 1})
    public_get_market_books = publicGetMarketBooks = Entry('market/books', 'public', 'GET', {'cost': 1})
    public_get_market_books_lite = publicGetMarketBooksLite = Entry('market/books-lite', 'public', 'GET', {'cost': 1.66})
    public_get_market_candles = publicGetMarketCandles = Entry('market/candles', 'public', 'GET', {'cost': 0.5})
    public_get_market_history_candles = publicGetMarketHistoryCandles = Entry('market/history-candles', 'public', 'GET', {'cost': 1})
    public_get_market_history_mark_price_candles = publicGetMarketHistoryMarkPriceCandles = Entry('market/history-mark-price-candles', 'public', 'GET', {'cost': 2})
    public_get_market_history_index_candles = publicGetMarketHistoryIndexCandles = Entry('market/history-index-candles', 'public', 'GET', {'cost': 2})
    public_get_market_index_candles = publicGetMarketIndexCandles = Entry('market/index-candles', 'public', 'GET', {'cost': 1})
    public_get_market_mark_price_candles = publicGetMarketMarkPriceCandles = Entry('market/mark-price-candles', 'public', 'GET', {'cost': 1})
    public_get_market_trades = publicGetMarketTrades = Entry('market/trades', 'public', 'GET', {'cost': 1})
    public_get_market_platform_24_volume = publicGetMarketPlatform24Volume = Entry('market/platform-24-volume', 'public', 'GET', {'cost': 10})
    public_get_market_open_oracle = publicGetMarketOpenOracle = Entry('market/open-oracle', 'public', 'GET', {'cost': 40})
    public_get_market_index_components = publicGetMarketIndexComponents = Entry('market/index-components', 'public', 'GET', {'cost': 1})
    public_get_market_option_instrument_family_trades = publicGetMarketOptionInstrumentFamilyTrades = Entry('market/option/instrument-family-trades', 'public', 'GET', {'cost': 1})
    public_get_public_instruments = publicGetPublicInstruments = Entry('public/instruments', 'public', 'GET', {'cost': 1})
    public_get_public_instrument_tick_bands = publicGetPublicInstrumentTickBands = Entry('public/instrument-tick-bands', 'public', 'GET', {'cost': 4})
    public_get_public_delivery_exercise_history = publicGetPublicDeliveryExerciseHistory = Entry('public/delivery-exercise-history', 'public', 'GET', {'cost': 0.5})
    public_get_public_open_interest = publicGetPublicOpenInterest = Entry('public/open-interest', 'public', 'GET', {'cost': 1})
    public_get_public_funding_rate = publicGetPublicFundingRate = Entry('public/funding-rate', 'public', 'GET', {'cost': 1})
    public_get_public_funding_rate_history = publicGetPublicFundingRateHistory = Entry('public/funding-rate-history', 'public', 'GET', {'cost': 1})
    public_get_public_price_limit = publicGetPublicPriceLimit = Entry('public/price-limit', 'public', 'GET', {'cost': 1})
    public_get_public_opt_summary = publicGetPublicOptSummary = Entry('public/opt-summary', 'public', 'GET', {'cost': 1})
    public_get_public_estimated_price = publicGetPublicEstimatedPrice = Entry('public/estimated-price', 'public', 'GET', {'cost': 2})
    public_get_public_discount_rate_interest_free_quota = publicGetPublicDiscountRateInterestFreeQuota = Entry('public/discount-rate-interest-free-quota', 'public', 'GET', {'cost': 10})
    public_get_public_time = publicGetPublicTime = Entry('public/time', 'public', 'GET', {'cost': 2})
    public_get_public_liquidation_orders = publicGetPublicLiquidationOrders = Entry('public/liquidation-orders', 'public', 'GET', {'cost': 0.5})
    public_get_public_mark_price = publicGetPublicMarkPrice = Entry('public/mark-price', 'public', 'GET', {'cost': 2})
    public_get_public_option_trades = publicGetPublicOptionTrades = Entry('public/option-trades', 'public', 'GET', {'cost': 1})
    public_get_public_position_tiers = publicGetPublicPositionTiers = Entry('public/position-tiers', 'public', 'GET', {'cost': 2})
    public_get_public_underlying = publicGetPublicUnderlying = Entry('public/underlying', 'public', 'GET', {'cost': 1})
    public_get_public_interest_rate_loan_quota = publicGetPublicInterestRateLoanQuota = Entry('public/interest-rate-loan-quota', 'public', 'GET', {'cost': 10})
    public_get_public_vip_interest_rate_loan_quota = publicGetPublicVipInterestRateLoanQuota = Entry('public/vip-interest-rate-loan-quota', 'public', 'GET', {'cost': 10})
    public_get_rubik_stat_trading_data_support_coin = publicGetRubikStatTradingDataSupportCoin = Entry('rubik/stat/trading-data/support-coin', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_taker_volume = publicGetRubikStatTakerVolume = Entry('rubik/stat/taker-volume', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_margin_loan_ratio = publicGetRubikStatMarginLoanRatio = Entry('rubik/stat/margin/loan-ratio', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_contracts_long_short_account_ratio = publicGetRubikStatContractsLongShortAccountRatio = Entry('rubik/stat/contracts/long-short-account-ratio', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_contracts_open_interest_volume = publicGetRubikStatContractsOpenInterestVolume = Entry('rubik/stat/contracts/open-interest-volume', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_option_open_interest_volume = publicGetRubikStatOptionOpenInterestVolume = Entry('rubik/stat/option/open-interest-volume', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_option_open_interest_volume_ratio = publicGetRubikStatOptionOpenInterestVolumeRatio = Entry('rubik/stat/option/open-interest-volume-ratio', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_option_open_interest_volume_expiry = publicGetRubikStatOptionOpenInterestVolumeExpiry = Entry('rubik/stat/option/open-interest-volume-expiry', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_option_open_interest_volume_strike = publicGetRubikStatOptionOpenInterestVolumeStrike = Entry('rubik/stat/option/open-interest-volume-strike', 'public', 'GET', {'cost': 4})
    public_get_rubik_stat_option_taker_block_volume = publicGetRubikStatOptionTakerBlockVolume = Entry('rubik/stat/option/taker-block-volume', 'public', 'GET', {'cost': 4})
    public_get_system_status = publicGetSystemStatus = Entry('system/status', 'public', 'GET', {'cost': 100})
    public_get_finance_savings_lending_rate_summary = publicGetFinanceSavingsLendingRateSummary = Entry('finance/savings/lending-rate-summary', 'public', 'GET', {'cost': 1.6666666666666667})
    public_get_finance_savings_lending_rate_history = publicGetFinanceSavingsLendingRateHistory = Entry('finance/savings/lending-rate-history', 'public', 'GET', {'cost': 1.6666666666666667})
    public_get_market_exchange_rate = publicGetMarketExchangeRate = Entry('market/exchange-rate', 'public', 'GET', {'cost': 20})
    private_get_account_account_position_risk = privateGetAccountAccountPositionRisk = Entry('account/account-position-risk', 'private', 'GET', {'cost': 2})
    private_get_account_balance = privateGetAccountBalance = Entry('account/balance', 'private', 'GET', {'cost': 2})
    private_get_account_positions = privateGetAccountPositions = Entry('account/positions', 'private', 'GET', {'cost': 2})
    private_get_account_positions_history = privateGetAccountPositionsHistory = Entry('account/positions-history', 'private', 'GET', {'cost': 2})
    private_get_account_bills = privateGetAccountBills = Entry('account/bills', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_account_bills_archive = privateGetAccountBillsArchive = Entry('account/bills-archive', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_account_config = privateGetAccountConfig = Entry('account/config', 'private', 'GET', {'cost': 4})
    private_get_account_max_size = privateGetAccountMaxSize = Entry('account/max-size', 'private', 'GET', {'cost': 1})
    private_get_account_max_avail_size = privateGetAccountMaxAvailSize = Entry('account/max-avail-size', 'private', 'GET', {'cost': 1})
    private_get_account_leverage_info = privateGetAccountLeverageInfo = Entry('account/leverage-info', 'private', 'GET', {'cost': 1})
    private_get_account_max_loan = privateGetAccountMaxLoan = Entry('account/max-loan', 'private', 'GET', {'cost': 1})
    private_get_account_trade_fee = privateGetAccountTradeFee = Entry('account/trade-fee', 'private', 'GET', {'cost': 4})
    private_get_account_interest_accrued = privateGetAccountInterestAccrued = Entry('account/interest-accrued', 'private', 'GET', {'cost': 4})
    private_get_account_interest_rate = privateGetAccountInterestRate = Entry('account/interest-rate', 'private', 'GET', {'cost': 4})
    private_get_account_max_withdrawal = privateGetAccountMaxWithdrawal = Entry('account/max-withdrawal', 'private', 'GET', {'cost': 1})
    private_get_account_risk_state = privateGetAccountRiskState = Entry('account/risk-state', 'private', 'GET', {'cost': 2})
    private_get_account_borrow_repay_history = privateGetAccountBorrowRepayHistory = Entry('account/borrow-repay-history', 'private', 'GET', {'cost': 4})
    private_get_account_quick_margin_borrow_repay_history = privateGetAccountQuickMarginBorrowRepayHistory = Entry('account/quick-margin-borrow-repay-history', 'private', 'GET', {'cost': 4})
    private_get_account_interest_limits = privateGetAccountInterestLimits = Entry('account/interest-limits', 'private', 'GET', {'cost': 4})
    private_get_account_vip_interest_accrued = privateGetAccountVipInterestAccrued = Entry('account/vip-interest-accrued', 'private', 'GET', {'cost': 4})
    private_get_account_vip_loan_order_list = privateGetAccountVipLoanOrderList = Entry('account/vip-loan-order-list', 'private', 'GET', {'cost': 4})
    private_get_account_vip_loan_order_detail = privateGetAccountVipLoanOrderDetail = Entry('account/vip-loan-order-detail', 'private', 'GET', {'cost': 4})
    private_get_asset_asset_valuation = privateGetAssetAssetValuation = Entry('asset/asset-valuation', 'private', 'GET', {'cost': 0.2})
    private_get_asset_deposit_address = privateGetAssetDepositAddress = Entry('asset/deposit-address', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_balances = privateGetAssetBalances = Entry('asset/balances', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_transfer_state = privateGetAssetTransferState = Entry('asset/transfer-state', 'private', 'GET', {'cost': 10})
    private_get_asset_deposit_history = privateGetAssetDepositHistory = Entry('asset/deposit-history', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_withdrawal_history = privateGetAssetWithdrawalHistory = Entry('asset/withdrawal-history', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_deposit_withdraw_status = privateGetAssetDepositWithdrawStatus = Entry('asset/deposit-withdraw-status', 'private', 'GET', {'cost': 20})
    private_get_asset_currencies = privateGetAssetCurrencies = Entry('asset/currencies', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_bills = privateGetAssetBills = Entry('asset/bills', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_piggy_balance = privateGetAssetPiggyBalance = Entry('asset/piggy-balance', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_deposit_lightning = privateGetAssetDepositLightning = Entry('asset/deposit-lightning', 'private', 'GET', {'cost': 5})
    private_get_asset_non_tradable_assets = privateGetAssetNonTradableAssets = Entry('asset/non-tradable-assets', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_trade_order = privateGetTradeOrder = Entry('trade/order', 'private', 'GET', {'cost': 0.3333333333333333})
    private_get_trade_orders_pending = privateGetTradeOrdersPending = Entry('trade/orders-pending', 'private', 'GET', {'cost': 1})
    private_get_trade_orders_history = privateGetTradeOrdersHistory = Entry('trade/orders-history', 'private', 'GET', {'cost': 0.5})
    private_get_trade_orders_history_archive = privateGetTradeOrdersHistoryArchive = Entry('trade/orders-history-archive', 'private', 'GET', {'cost': 1})
    private_get_trade_fills = privateGetTradeFills = Entry('trade/fills', 'private', 'GET', {'cost': 0.3333333333333333})
    private_get_trade_fills_history = privateGetTradeFillsHistory = Entry('trade/fills-history', 'private', 'GET', {'cost': 2})
    private_get_trade_orders_algo_pending = privateGetTradeOrdersAlgoPending = Entry('trade/orders-algo-pending', 'private', 'GET', {'cost': 1})
    private_get_trade_orders_algo_history = privateGetTradeOrdersAlgoHistory = Entry('trade/orders-algo-history', 'private', 'GET', {'cost': 1})
    private_get_trade_order_algo = privateGetTradeOrderAlgo = Entry('trade/order-algo', 'private', 'GET', {'cost': 1})
    private_get_account_subaccount_balances = privateGetAccountSubaccountBalances = Entry('account/subaccount/balances', 'private', 'GET', {'cost': 10})
    private_get_account_subaccount_interest_limits = privateGetAccountSubaccountInterestLimits = Entry('account/subaccount/interest-limits', 'private', 'GET', {'cost': 4})
    private_get_asset_subaccount_bills = privateGetAssetSubaccountBills = Entry('asset/subaccount/bills', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_users_subaccount_list = privateGetUsersSubaccountList = Entry('users/subaccount/list', 'private', 'GET', {'cost': 10})
    private_get_users_subaccount_apikey = privateGetUsersSubaccountApikey = Entry('users/subaccount/apikey', 'private', 'GET', {'cost': 10})
    private_get_users_entrust_subaccount_list = privateGetUsersEntrustSubaccountList = Entry('users/entrust-subaccount-list', 'private', 'GET', {'cost': 10})
    private_get_broker_nd_info = privateGetBrokerNdInfo = Entry('broker/nd/info', 'private', 'GET', {'cost': 10})
    private_get_broker_nd_subaccount_info = privateGetBrokerNdSubaccountInfo = Entry('broker/nd/subaccount-info', 'private', 'GET', {'cost': 10})
    private_get_asset_broker_nd_subaccount_deposit_address = privateGetAssetBrokerNdSubaccountDepositAddress = Entry('asset/broker/nd/subaccount-deposit-address', 'private', 'GET', {'cost': 4})
    private_get_asset_broker_nd_subaccount_deposit_history = privateGetAssetBrokerNdSubaccountDepositHistory = Entry('asset/broker/nd/subaccount-deposit-history', 'private', 'GET', {'cost': 4})
    private_get_broker_nd_rebate_daily = privateGetBrokerNdRebateDaily = Entry('broker/nd/rebate-daily', 'private', 'GET', {'cost': 1})
    private_get_broker_nd_subaccount_apikey = privateGetBrokerNdSubaccountApikey = Entry('broker/nd/subaccount/apikey', 'private', 'GET', {'cost': 10})
    private_get_broker_nd_rebate_per_orders = privateGetBrokerNdRebatePerOrders = Entry('broker/nd/rebate-per-orders', 'private', 'GET', {'cost': 300})
    private_get_asset_broker_nd_subaccount_withdrawal_history = privateGetAssetBrokerNdSubaccountWithdrawalHistory = Entry('asset/broker/nd/subaccount-withdrawal-history', 'private', 'GET', {'cost': 4})
    private_get_asset_convert_currencies = privateGetAssetConvertCurrencies = Entry('asset/convert/currencies', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_convert_currency_pair = privateGetAssetConvertCurrencyPair = Entry('asset/convert/currency-pair', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_asset_convert_estimate_quote = privateGetAssetConvertEstimateQuote = Entry('asset/convert/estimate-quote', 'private', 'GET', {'cost': 5})
    private_get_asset_convert_trade = privateGetAssetConvertTrade = Entry('asset/convert/trade', 'private', 'GET', {'cost': 5})
    private_get_asset_convert_history = privateGetAssetConvertHistory = Entry('asset/convert/history', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_account_greeks = privateGetAccountGreeks = Entry('account/greeks', 'private', 'GET', {'cost': 2})
    private_get_finance_staking_defi_offers = privateGetFinanceStakingDefiOffers = Entry('finance/staking-defi/offers', 'private', 'GET', {'cost': 1})
    private_get_finance_staking_defi_orders_active = privateGetFinanceStakingDefiOrdersActive = Entry('finance/staking-defi/orders-active', 'private', 'GET', {'cost': 1})
    private_get_finance_staking_defi_orders_history = privateGetFinanceStakingDefiOrdersHistory = Entry('finance/staking-defi/orders-history', 'private', 'GET', {'cost': 1})
    private_get_finance_savings_balance = privateGetFinanceSavingsBalance = Entry('finance/savings/balance', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_finance_savings_lending_history = privateGetFinanceSavingsLendingHistory = Entry('finance/savings/lending-history', 'private', 'GET', {'cost': 1.6666666666666667})
    private_get_rfq_counterparties = privateGetRfqCounterparties = Entry('rfq/counterparties', 'private', 'GET', {'cost': 4})
    private_get_rfq_maker_instrument_settings = privateGetRfqMakerInstrumentSettings = Entry('rfq/maker-instrument-settings', 'private', 'GET', {'cost': 4})
    private_get_rfq_rfqs = privateGetRfqRfqs = Entry('rfq/rfqs', 'private', 'GET', {'cost': 10})
    private_get_rfq_quotes = privateGetRfqQuotes = Entry('rfq/quotes', 'private', 'GET', {'cost': 10})
    private_get_rfq_trades = privateGetRfqTrades = Entry('rfq/trades', 'private', 'GET', {'cost': 4})
    private_get_rfq_public_trades = privateGetRfqPublicTrades = Entry('rfq/public-trades', 'private', 'GET', {'cost': 4})
    private_get_copytrading_current_subpositions = privateGetCopytradingCurrentSubpositions = Entry('copytrading/current-subpositions', 'private', 'GET', {'cost': 10})
    private_get_copytrading_subpositions_history = privateGetCopytradingSubpositionsHistory = Entry('copytrading/subpositions-history', 'private', 'GET', {'cost': 10})
    private_get_copytrading_instruments = privateGetCopytradingInstruments = Entry('copytrading/instruments', 'private', 'GET', {'cost': 10})
    private_get_copytrading_profit_sharing_details = privateGetCopytradingProfitSharingDetails = Entry('copytrading/profit-sharing-details', 'private', 'GET', {'cost': 10})
    private_get_copytrading_total_profit_sharing = privateGetCopytradingTotalProfitSharing = Entry('copytrading/total-profit-sharing', 'private', 'GET', {'cost': 10})
    private_get_copytrading_unrealized_profit_sharing_details = privateGetCopytradingUnrealizedProfitSharingDetails = Entry('copytrading/unrealized-profit-sharing-details', 'private', 'GET', {'cost': 10})
    private_get_tradingbot_grid_orders_algo_pending = privateGetTradingBotGridOrdersAlgoPending = Entry('tradingBot/grid/orders-algo-pending', 'private', 'GET', {'cost': 1})
    private_get_tradingbot_grid_orders_algo_history = privateGetTradingBotGridOrdersAlgoHistory = Entry('tradingBot/grid/orders-algo-history', 'private', 'GET', {'cost': 1})
    private_get_tradingbot_grid_orders_algo_details = privateGetTradingBotGridOrdersAlgoDetails = Entry('tradingBot/grid/orders-algo-details', 'private', 'GET', {'cost': 1})
    private_get_tradingbot_grid_sub_orders = privateGetTradingBotGridSubOrders = Entry('tradingBot/grid/sub-orders', 'private', 'GET', {'cost': 1})
    private_get_tradingbot_grid_positions = privateGetTradingBotGridPositions = Entry('tradingBot/grid/positions', 'private', 'GET', {'cost': 1})
    private_get_tradingbot_grid_ai_param = privateGetTradingBotGridAiParam = Entry('tradingBot/grid/ai-param', 'private', 'GET', {'cost': 1})
    private_post_account_set_position_mode = privatePostAccountSetPositionMode = Entry('account/set-position-mode', 'private', 'POST', {'cost': 4})
    private_post_account_set_leverage = privatePostAccountSetLeverage = Entry('account/set-leverage', 'private', 'POST', {'cost': 1})
    private_post_account_position_margin_balance = privatePostAccountPositionMarginBalance = Entry('account/position/margin-balance', 'private', 'POST', {'cost': 1})
    private_post_account_set_greeks = privatePostAccountSetGreeks = Entry('account/set-greeks', 'private', 'POST', {'cost': 4})
    private_post_account_set_isolated_mode = privatePostAccountSetIsolatedMode = Entry('account/set-isolated-mode', 'private', 'POST', {'cost': 4})
    private_post_account_set_riskoffset_type = privatePostAccountSetRiskOffsetType = Entry('account/set-riskOffset-type', 'private', 'POST', {'cost': 2})
    private_post_account_simulated_margin = privatePostAccountSimulatedMargin = Entry('account/simulated_margin', 'private', 'POST', {'cost': 10})
    private_post_account_borrow_repay = privatePostAccountBorrowRepay = Entry('account/borrow-repay', 'private', 'POST', {'cost': 1.6666666666666667})
    private_post_account_quick_margin_borrow_repay = privatePostAccountQuickMarginBorrowRepay = Entry('account/quick-margin-borrow-repay', 'private', 'POST', {'cost': 4})
    private_post_account_activate_option = privatePostAccountActivateOption = Entry('account/activate-option', 'private', 'POST', {'cost': 4})
    private_post_account_set_auto_loan = privatePostAccountSetAutoLoan = Entry('account/set-auto-loan', 'private', 'POST', {'cost': 4})
    private_post_account_subaccount_set_loan_allocation = privatePostAccountSubaccountSetLoanAllocation = Entry('account/subaccount/set-loan-allocation', 'private', 'POST', {'cost': 4})
    private_post_asset_transfer = privatePostAssetTransfer = Entry('asset/transfer', 'private', 'POST', {'cost': 10})
    private_post_asset_withdrawal = privatePostAssetWithdrawal = Entry('asset/withdrawal', 'private', 'POST', {'cost': 1.6666666666666667})
    private_post_asset_withdrawal_lightning = privatePostAssetWithdrawalLightning = Entry('asset/withdrawal-lightning', 'private', 'POST', {'cost': 5})
    private_post_asset_cancel_withdrawal = privatePostAssetCancelWithdrawal = Entry('asset/cancel-withdrawal', 'private', 'POST', {'cost': 1.6666666666666667})
    private_post_asset_convert_dust_assets = privatePostAssetConvertDustAssets = Entry('asset/convert-dust-assets', 'private', 'POST', {'cost': 10})
    private_post_trade_order = privatePostTradeOrder = Entry('trade/order', 'private', 'POST', {'cost': 0.3333333333333333})
    private_post_trade_batch_orders = privatePostTradeBatchOrders = Entry('trade/batch-orders', 'private', 'POST', {'cost': 0.06666666666666667})
    private_post_trade_cancel_order = privatePostTradeCancelOrder = Entry('trade/cancel-order', 'private', 'POST', {'cost': 0.3333333333333333})
    private_post_trade_cancel_batch_orders = privatePostTradeCancelBatchOrders = Entry('trade/cancel-batch-orders', 'private', 'POST', {'cost': 0.06666666666666667})
    private_post_trade_amend_order = privatePostTradeAmendOrder = Entry('trade/amend-order', 'private', 'POST', {'cost': 0.3333333333333333})
    private_post_trade_amend_batch_orders = privatePostTradeAmendBatchOrders = Entry('trade/amend-batch-orders', 'private', 'POST', {'cost': 0.3333333333333333})
    private_post_trade_amend_algos = privatePostTradeAmendAlgos = Entry('trade/amend-algos', 'private', 'POST', {'cost': 1})
    private_post_trade_close_position = privatePostTradeClosePosition = Entry('trade/close-position', 'private', 'POST', {'cost': 1})
    private_post_trade_order_algo = privatePostTradeOrderAlgo = Entry('trade/order-algo', 'private', 'POST', {'cost': 1})
    private_post_trade_cancel_algos = privatePostTradeCancelAlgos = Entry('trade/cancel-algos', 'private', 'POST', {'cost': 1})
    private_post_trade_cancel_advance_algos = privatePostTradeCancelAdvanceAlgos = Entry('trade/cancel-advance-algos', 'private', 'POST', {'cost': 1})
    private_post_users_subaccount_delete_apikey = privatePostUsersSubaccountDeleteApikey = Entry('users/subaccount/delete-apikey', 'private', 'POST', {'cost': 10})
    private_post_users_subaccount_modify_apikey = privatePostUsersSubaccountModifyApikey = Entry('users/subaccount/modify-apikey', 'private', 'POST', {'cost': 10})
    private_post_users_subaccount_apikey = privatePostUsersSubaccountApikey = Entry('users/subaccount/apikey', 'private', 'POST', {'cost': 10})
    private_post_users_subaccount_set_transfer_out = privatePostUsersSubaccountSetTransferOut = Entry('users/subaccount/set-transfer-out', 'private', 'POST', {'cost': 10})
    private_post_asset_subaccount_transfer = privatePostAssetSubaccountTransfer = Entry('asset/subaccount/transfer', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_create_subaccount = privatePostBrokerNdCreateSubaccount = Entry('broker/nd/create-subaccount', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_delete_subaccount = privatePostBrokerNdDeleteSubaccount = Entry('broker/nd/delete-subaccount', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_set_subaccount_level = privatePostBrokerNdSetSubaccountLevel = Entry('broker/nd/set-subaccount-level', 'private', 'POST', {'cost': 4})
    private_post_broker_nd_set_subaccount_fee_rate = privatePostBrokerNdSetSubaccountFeeRate = Entry('broker/nd/set-subaccount-fee-rate', 'private', 'POST', {'cost': 4})
    private_post_asset_broker_nd_subaccount_deposit_address = privatePostAssetBrokerNdSubaccountDepositAddress = Entry('asset/broker/nd/subaccount-deposit-address', 'private', 'POST', {'cost': 4})
    private_post_broker_nd_subaccount_apikey = privatePostBrokerNdSubaccountApikey = Entry('broker/nd/subaccount/apikey', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_subaccount_delete_apikey = privatePostBrokerNdSubaccountDeleteApikey = Entry('broker/nd/subaccount/delete-apikey', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_subaccount_modify_apikey = privatePostBrokerNdSubaccountModifyApikey = Entry('broker/nd/subaccount/modify-apikey', 'private', 'POST', {'cost': 10})
    private_post_broker_nd_rebate_per_orders = privatePostBrokerNdRebatePerOrders = Entry('broker/nd/rebate-per-orders', 'private', 'POST', {'cost': 36000})
    private_post_finance_staking_defi_purchase = privatePostFinanceStakingDefiPurchase = Entry('finance/staking-defi/purchase', 'private', 'POST', {'cost': 3})
    private_post_finance_staking_defi_redeem = privatePostFinanceStakingDefiRedeem = Entry('finance/staking-defi/redeem', 'private', 'POST', {'cost': 3})
    private_post_finance_staking_defi_cancel = privatePostFinanceStakingDefiCancel = Entry('finance/staking-defi/cancel', 'private', 'POST', {'cost': 3})
    private_post_finance_savings_purchase_redempt = privatePostFinanceSavingsPurchaseRedempt = Entry('finance/savings/purchase-redempt', 'private', 'POST', {'cost': 1.6666666666666667})
    private_post_finance_savings_set_lending_rate = privatePostFinanceSavingsSetLendingRate = Entry('finance/savings/set-lending-rate', 'private', 'POST', {'cost': 1.6666666666666667})
    private_post_rfq_create_rfq = privatePostRfqCreateRfq = Entry('rfq/create-rfq', 'private', 'POST', {'cost': 4})
    private_post_rfq_cancel_rfq = privatePostRfqCancelRfq = Entry('rfq/cancel-rfq', 'private', 'POST', {'cost': 4})
    private_post_rfq_cancel_batch_rfqs = privatePostRfqCancelBatchRfqs = Entry('rfq/cancel-batch-rfqs', 'private', 'POST', {'cost': 10})
    private_post_rfq_cancel_all_rfqs = privatePostRfqCancelAllRfqs = Entry('rfq/cancel-all-rfqs', 'private', 'POST', {'cost': 10})
    private_post_rfq_execute_quote = privatePostRfqExecuteQuote = Entry('rfq/execute-quote', 'private', 'POST', {'cost': 10})
    private_post_rfq_maker_instrument_settings = privatePostRfqMakerInstrumentSettings = Entry('rfq/maker-instrument-settings', 'private', 'POST', {'cost': 4})
    private_post_rfq_mmp_reset = privatePostRfqMmpReset = Entry('rfq/mmp-reset', 'private', 'POST', {'cost': 4})
    private_post_rfq_create_quote = privatePostRfqCreateQuote = Entry('rfq/create-quote', 'private', 'POST', {'cost': 0.4})
    private_post_rfq_cancel_quote = privatePostRfqCancelQuote = Entry('rfq/cancel-quote', 'private', 'POST', {'cost': 0.4})
    private_post_rfq_cancel_batch_quotes = privatePostRfqCancelBatchQuotes = Entry('rfq/cancel-batch-quotes', 'private', 'POST', {'cost': 10})
    private_post_rfq_cancel_all_quotes = privatePostRfqCancelAllQuotes = Entry('rfq/cancel-all-quotes', 'private', 'POST', {'cost': 10})
    private_post_copytrading_algo_order = privatePostCopytradingAlgoOrder = Entry('copytrading/algo-order', 'private', 'POST', {'cost': 20})
    private_post_copytrading_close_subposition = privatePostCopytradingCloseSubposition = Entry('copytrading/close-subposition', 'private', 'POST', {'cost': 10})
    private_post_copytrading_set_instruments = privatePostCopytradingSetInstruments = Entry('copytrading/set-instruments', 'private', 'POST', {'cost': 10})
    private_post_tradingbot_grid_order_algo = privatePostTradingBotGridOrderAlgo = Entry('tradingBot/grid/order-algo', 'private', 'POST', {'cost': 1})
    private_post_tradingbot_grid_amend_order_algo = privatePostTradingBotGridAmendOrderAlgo = Entry('tradingBot/grid/amend-order-algo', 'private', 'POST', {'cost': 1})
    private_post_tradingbot_grid_stop_order_algo = privatePostTradingBotGridStopOrderAlgo = Entry('tradingBot/grid/stop-order-algo', 'private', 'POST', {'cost': 1})
    private_post_tradingbot_grid_withdraw_income = privatePostTradingBotGridWithdrawIncome = Entry('tradingBot/grid/withdraw-income', 'private', 'POST', {'cost': 1})
    private_post_tradingbot_grid_compute_margin_balance = privatePostTradingBotGridComputeMarginBalance = Entry('tradingBot/grid/compute-margin-balance', 'private', 'POST', {'cost': 1})
    private_post_tradingbot_grid_margin_balance = privatePostTradingBotGridMarginBalance = Entry('tradingBot/grid/margin-balance', 'private', 'POST', {'cost': 1})
