from ccxt.base.types import Entry


class ImplicitAPI:
    public_get_currencies = publicGetCurrencies = Entry('currencies', 'public', 'GET', {'cost': 1})
    public_get_currencies_currencyid = publicGetCurrenciesCurrencyId = Entry('currencies/{currencyId}', 'public', 'GET', {'cost': 1})
    public_get_markets = publicGetMarkets = Entry('markets', 'public', 'GET', {'cost': 1})
    public_get_pairs_groups = publicGetPairsGroups = Entry('pairs-groups', 'public', 'GET', {'cost': 1})
    public_get_currency_pairs_list_code = publicGetCurrencyPairsListCode = Entry('currency_pairs/list/{code}', 'public', 'GET', {'cost': 1})
    public_get_currency_pairs_group_currencypairgroupid = publicGetCurrencyPairsGroupCurrencyPairGroupId = Entry('currency_pairs/group/{currencyPairGroupId}', 'public', 'GET', {'cost': 1})
    public_get_currency_pairs_currencypairid = publicGetCurrencyPairsCurrencyPairId = Entry('currency_pairs/{currencyPairId}', 'public', 'GET', {'cost': 1})
    public_get_ticker = publicGetTicker = Entry('ticker', 'public', 'GET', {'cost': 1})
    public_get_ticker_currencypairid = publicGetTickerCurrencyPairId = Entry('ticker/{currencyPairId}', 'public', 'GET', {'cost': 1})
    public_get_trades_currencypairid = publicGetTradesCurrencyPairId = Entry('trades/{currencyPairId}', 'public', 'GET', {'cost': 1})
    public_get_orderbook_currencypairid = publicGetOrderbookCurrencyPairId = Entry('orderbook/{currencyPairId}', 'public', 'GET', {'cost': 1})
    public_get_chart_currencypairid_candlestype = publicGetChartCurrencyPairIdCandlesType = Entry('chart/{currencyPairId}/{candlesType}', 'public', 'GET', {'cost': 1})
    public_get_deposit_statuses = publicGetDepositStatuses = Entry('deposit-statuses', 'public', 'GET', {'cost': 1})
    public_get_deposit_statuses_statusid = publicGetDepositStatusesStatusId = Entry('deposit-statuses/{statusId}', 'public', 'GET', {'cost': 1})
    public_get_withdrawal_statuses = publicGetWithdrawalStatuses = Entry('withdrawal-statuses', 'public', 'GET', {'cost': 1})
    public_get_withdrawal_statuses_statusid = publicGetWithdrawalStatusesStatusId = Entry('withdrawal-statuses/{statusId}', 'public', 'GET', {'cost': 1})
    public_get_ping = publicGetPing = Entry('ping', 'public', 'GET', {'cost': 1})
    public_get_mobile_versions = publicGetMobileVersions = Entry('mobile-versions', 'public', 'GET', {'cost': 1})
    public_get_twitter = publicGetTwitter = Entry('twitter', 'public', 'GET', {'cost': 1})
    trading_get_fees_currencypairid = tradingGetFeesCurrencyPairId = Entry('fees/{currencyPairId}', 'trading', 'GET', {'cost': 1})
    trading_get_orders = tradingGetOrders = Entry('orders', 'trading', 'GET', {'cost': 12})
    trading_get_orders_currencypairid = tradingGetOrdersCurrencyPairId = Entry('orders/{currencyPairId}', 'trading', 'GET', {'cost': 6})
    trading_get_order_orderid = tradingGetOrderOrderId = Entry('order/{orderId}', 'trading', 'GET', {'cost': 12})
    trading_post_orders_currencypairid = tradingPostOrdersCurrencyPairId = Entry('orders/{currencyPairId}', 'trading', 'POST', {'cost': 1.5})
    trading_post_orders_bulk_currencypairid = tradingPostOrdersBulkCurrencyPairId = Entry('orders/bulk/{currencyPairId}', 'trading', 'POST', {'cost': 12})
    trading_delete_orders = tradingDeleteOrders = Entry('orders', 'trading', 'DELETE', {'cost': 30})
    trading_delete_orders_currencypairid = tradingDeleteOrdersCurrencyPairId = Entry('orders/{currencyPairId}', 'trading', 'DELETE', {'cost': 12})
    trading_delete_order_orderid = tradingDeleteOrderOrderId = Entry('order/{orderId}', 'trading', 'DELETE', {'cost': 1.5})
    reports_get_currencies = reportsGetCurrencies = Entry('currencies', 'reports', 'GET', {'cost': 12})
    reports_get_currency_pairs = reportsGetCurrencyPairs = Entry('currency_pairs', 'reports', 'GET', {'cost': 12})
    reports_get_orders = reportsGetOrders = Entry('orders', 'reports', 'GET', {'cost': 12})
    reports_get_orders_orderid = reportsGetOrdersOrderId = Entry('orders/{orderId}', 'reports', 'GET', {'cost': 12})
    reports_get_trades_currencypairid = reportsGetTradesCurrencyPairId = Entry('trades/{currencyPairId}', 'reports', 'GET', {'cost': 12})
    reports_get_background_listmode = reportsGetBackgroundListMode = Entry('background/{listMode}', 'reports', 'GET', {'cost': 12})
    reports_get_background_id = reportsGetBackgroundId = Entry('background/{id}', 'reports', 'GET', {'cost': 12})
    reports_get_background_download_id = reportsGetBackgroundDownloadId = Entry('background/download/{id}', 'reports', 'GET', {'cost': 12})
    reports_post_background_create = reportsPostBackgroundCreate = Entry('background/create', 'reports', 'POST', {'cost': 12})
    reports_delete_background_id = reportsDeleteBackgroundId = Entry('background/{id}', 'reports', 'DELETE', {'cost': 12})
    profile_get_info = profileGetInfo = Entry('info', 'profile', 'GET', {'cost': 3})
    profile_get_wallets = profileGetWallets = Entry('wallets', 'profile', 'GET', {'cost': 3})
    profile_get_wallets_walletid = profileGetWalletsWalletId = Entry('wallets/{walletId}', 'profile', 'GET', {'cost': 3})
    profile_get_wallets_address_walletid = profileGetWalletsAddressWalletId = Entry('wallets/address/{walletId}', 'profile', 'GET', {'cost': 3})
    profile_get_deposits = profileGetDeposits = Entry('deposits', 'profile', 'GET', {'cost': 3})
    profile_get_deposits_id = profileGetDepositsId = Entry('deposits/{id}', 'profile', 'GET', {'cost': 3})
    profile_get_rewards = profileGetRewards = Entry('rewards', 'profile', 'GET', {'cost': 3})
    profile_get_rewards_id = profileGetRewardsId = Entry('rewards/{id}', 'profile', 'GET', {'cost': 3})
    profile_get_addressbook = profileGetAddressbook = Entry('addressbook', 'profile', 'GET', {'cost': 3})
    profile_get_addressbook_itemid = profileGetAddressbookItemId = Entry('addressbook/{itemId}', 'profile', 'GET', {'cost': 3})
    profile_get_withdrawals = profileGetWithdrawals = Entry('withdrawals', 'profile', 'GET', {'cost': 3})
    profile_get_withdrawals_id = profileGetWithdrawalsId = Entry('withdrawals/{id}', 'profile', 'GET', {'cost': 3})
    profile_get_notifications = profileGetNotifications = Entry('notifications', 'profile', 'GET', {'cost': 3})
    profile_get_notifications_price = profileGetNotificationsPrice = Entry('notifications/price', 'profile', 'GET', {'cost': 3})
    profile_get_favorite_currency_pairs = profileGetFavoriteCurrencyPairs = Entry('favorite/currency_pairs', 'profile', 'GET', {'cost': 3})
    profile_get_token_scopes = profileGetTokenScopes = Entry('token-scopes', 'profile', 'GET', {'cost': 3})
    profile_post_wallets_burn_walletid = profilePostWalletsBurnWalletId = Entry('wallets/burn/{walletId}', 'profile', 'POST', {'cost': 3})
    profile_post_wallets_walletid_hold_amount = profilePostWalletsWalletIdHoldAmount = Entry('wallets/{walletId}/hold_amount', 'profile', 'POST', {'cost': 3})
    profile_post_wallets_currencyid = profilePostWalletsCurrencyId = Entry('wallets/{currencyId}', 'profile', 'POST', {'cost': 3})
    profile_post_wallets_address_walletid = profilePostWalletsAddressWalletId = Entry('wallets/address/{walletId}', 'profile', 'POST', {'cost': 3})
    profile_post_addressbook_disable_item_itemid = profilePostAddressbookDisableItemItemId = Entry('addressbook/disable_item/{itemId}', 'profile', 'POST', {'cost': 3})
    profile_post_addressbook_enable_item_itemid = profilePostAddressbookEnableItemItemId = Entry('addressbook/enable_item/{itemId}', 'profile', 'POST', {'cost': 3})
    profile_post_addressbook_enable_strict_wd = profilePostAddressbookEnableStrictWd = Entry('addressbook/enable_strict_wd', 'profile', 'POST', {'cost': 3})
    profile_post_addressbook_disable_strict_wd = profilePostAddressbookDisableStrictWd = Entry('addressbook/disable_strict_wd', 'profile', 'POST', {'cost': 3})
    profile_post_withdraw = profilePostWithdraw = Entry('withdraw', 'profile', 'POST', {'cost': 30})
    profile_post_notifications_price = profilePostNotificationsPrice = Entry('notifications/price', 'profile', 'POST', {'cost': 3})
    profile_post_referral_program = profilePostReferralProgram = Entry('referral/program', 'profile', 'POST', {'cost': 3})
    profile_post_referral_insert_code = profilePostReferralInsertCode = Entry('referral/insert/{code}', 'profile', 'POST', {'cost': 3})
    profile_post_referral_bonus_transfer_currencyid = profilePostReferralBonusTransferCurrencyId = Entry('referral/bonus_transfer/{currencyId}', 'profile', 'POST', {'cost': 3})
    profile_put_favorite_currency_pairs_set = profilePutFavoriteCurrencyPairsSet = Entry('favorite/currency_pairs/set', 'profile', 'PUT', {'cost': 3})
    profile_delete_addressbook_itemid = profileDeleteAddressbookItemId = Entry('addressbook/{itemId}', 'profile', 'DELETE', {'cost': 3})
    profile_delete_withdraw_withdrawalid = profileDeleteWithdrawWithdrawalId = Entry('withdraw/{withdrawalId}', 'profile', 'DELETE', {'cost': 30})
    profile_delete_notifications_price_pricealertid = profileDeleteNotificationsPricePriceAlertId = Entry('notifications/price/{priceAlertId}', 'profile', 'DELETE', {'cost': 3})
    verification_get_countries = verificationGetCountries = Entry('countries', 'verification', 'GET', {'cost': 1})
    verification_get_status = verificationGetStatus = Entry('status', 'verification', 'GET', {'cost': 1})
    verification_get_fractal_url = verificationGetFractalUrl = Entry('fractal/url', 'verification', 'GET', {'cost': 1})
    verification_get_smart_id = verificationGetSmartId = Entry('smart-id', 'verification', 'GET', {'cost': 1})
    verification_get_stex = verificationGetStex = Entry('stex', 'verification', 'GET', {'cost': 1})
    verification_get_cryptonomica_code = verificationGetCryptonomicaCode = Entry('cryptonomica/code', 'verification', 'GET', {'cost': 1})
    verification_post_smart_id = verificationPostSmartId = Entry('smart-id', 'verification', 'POST', {'cost': 1})
    verification_post_stex = verificationPostStex = Entry('stex', 'verification', 'POST', {'cost': 1})
    verification_post_cryptonomica = verificationPostCryptonomica = Entry('cryptonomica', 'verification', 'POST', {'cost': 1})
    settings_get_notifications_event = settingsGetNotificationsEvent = Entry('notifications/{event}', 'settings', 'GET', {'cost': 1})
    settings_get_notifications = settingsGetNotifications = Entry('notifications', 'settings', 'GET', {'cost': 1})
    settings_put_notifications = settingsPutNotifications = Entry('notifications', 'settings', 'PUT', {'cost': 1})
    settings_put_notifications_set = settingsPutNotificationsSet = Entry('notifications/set', 'settings', 'PUT', {'cost': 1})
