demo1 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-10'
正回购资产_明细 = 资产(['债券'], ['久期', '持仓市值']) in 产品(['净值类'], ['总资产', '净资产', '杠杆率'])
正回购资产合计 = agg(正回购资产_明细, ['产品代码', '产品简称'], {'持仓市值': 'sum', '净资产': 'first', '杠杆率': 'first'})
持仓占比 = alias(正回购资产合计.持仓市值 / 正回购资产合计.净资产, '正回购占比')
监控规则 = {'触发超限': '正回购占比 > 0.44', '触发预警': '(正回购占比 <= 0.44) & (正回购占比 > 0.41)', '正常': '正回购占比 <= 0.41'}
'''

demo2 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-20'
资产指标库 = 指标('估值明细指标库', ['持仓市值'], {'port_tags': ['公募开放式', '封闭式'], 'asset_tags': ['债券', '债券回购']})
'''

demo3 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-20'
资产指标库 = 指标('估值明细指标库', ['持仓市值'], {'port_tags': ['公募开放式', '封闭式'], 'asset_tags': ['债券', '债券回购']})
最大持仓市值 = max(资产指标库, '持仓市值')
最小持仓市值 = min(资产指标库, '持仓市值')
平均持仓市值 = mean(资产指标库, '持仓市值')
持仓个数 = count(资产指标库, '持仓市值')
持仓中位数 = median(资产指标库, '持仓市值')
排序后资产指标库 = sort(资产指标库, ['持仓市值'], '降序')
'''

demo4 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-20'
资产指标库 = 指标('估值明细指标库', ['持仓市值'], {'port_tags': ['公募开放式', '封闭式'], 'asset_tags': ['债券', '债券回购']})
债券库 = filter(资产指标库, '债券 == "是"')
回购库 = filter(资产指标库, '债券回购 == "是"')
全部库 = concat(债券库, 回购库)
'''

demo5 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-20'
资产指标库 = 指标('估值明细指标库', ['持仓市值'], {'port_tags': ['公募开放式', '封闭式'], 'asset_tags': ['债券', '债券回购']})
排序后指标库 = sort(资产指标库, ['持仓市值'], '降序')
前十大持仓资产 = limit(排序后指标库, 10)
'''

demo6 = '''开始日期 = '2024-04-10'
结束日期 = '2024-04-20'
port_tags = ['公募开放式', '封闭式']
asset_tags = ['债券', '债券回购']
资产指标库 = 指标('估值明细指标库', ['持仓市值'], {'port_tags': port_tags, 'asset_tags': asset_tags})
排序后指标库 = sort(资产指标库, ['持仓市值'], '降序')
前十大持仓资产 = limit(排序后指标库, 10)
'''
