# Generated by Django 5.1.2 on 2025-05-23 10:49

import django.db.models.deletion
from django.db import migrations, models
import lunes_cms.cms.models.static
import lunes_cms.cms.validators


class Migration(migrations.Migration):
    """
    Initial migration that creates the core models for the application.

    This migration creates the following models:
    - Job: Represents a job category
    - Word: Represents a vocabulary word with its attributes
    - Unit: Represents a learning unit that contains words and belongs to jobs
    """

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "released",
                    models.BooleanField(default=False, verbose_name="released"),
                ),
                ("title", models.CharField(max_length=255, verbose_name="job")),
                (
                    "icon",
                    models.ImageField(
                        blank=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_images,
                        verbose_name="icon",
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="created at"),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, verbose_name="modified at"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="job",
                        to="auth.group",
                        verbose_name="created by",
                    ),
                ),
            ],
            options={
                "verbose_name": "job",
                "verbose_name_plural": "jobs",
            },
        ),
        migrations.CreateModel(
            name="Word",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "word_type",
                    models.CharField(
                        choices=[
                            ("Nomen", "Substantiv"),
                            ("Verb", "Verb"),
                            ("Adjektiv", "Adjektiv"),
                            ("Numeral", "Numeral"),
                            ("Pronomen", "Pronomen"),
                            ("Adverb", "Adverb"),
                        ],
                        default="",
                        max_length=255,
                        verbose_name="word type",
                    ),
                ),
                ("word", models.CharField(max_length=255, verbose_name="word")),
                (
                    "grammatical_gender",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "kein"),
                            (1, "Maskulinum"),
                            (2, "Femininum"),
                            (3, "Neutrum"),
                            (4, "Plural"),
                        ],
                        null=True,
                        verbose_name="Grammatical gender",
                    ),
                ),
                (
                    "singular_article",
                    models.IntegerField(
                        choices=[
                            (0, "keiner"),
                            (1, "der"),
                            (2, "die"),
                            (3, "das"),
                            (4, "die (Plural)"),
                        ],
                        default="",
                        verbose_name="singular article",
                    ),
                ),
                (
                    "plural",
                    models.CharField(
                        blank=True, default="", max_length=255, verbose_name="plural"
                    ),
                ),
                (
                    "plural_article",
                    models.IntegerField(
                        blank=True,
                        choices=[(0, "keiner"), (1, "die (Plural)")],
                        null=True,
                        verbose_name="plural article",
                    ),
                ),
                (
                    "audio",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_audio,
                        validators=[
                            lunes_cms.cms.validators.validate_file_extension,
                            lunes_cms.cms.validators.validate_file_size,
                            lunes_cms.cms.validators.validate_multiple_extensions,
                        ],
                        verbose_name="audio",
                    ),
                ),
                (
                    "example_sentence",
                    models.TextField(blank=True, verbose_name="example sentence"),
                ),
                (
                    "creation_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="creation date"
                    ),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, verbose_name="modified at"),
                ),
                (
                    "definition",
                    models.TextField(
                        blank=True, max_length=256, null=True, verbose_name="definition"
                    ),
                ),
                (
                    "additional_meaning_1",
                    models.CharField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="additional meaning 1",
                    ),
                ),
                (
                    "additional_meaning_2",
                    models.CharField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="additional meaning 2",
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        max_length=255,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="auth.group",
                        verbose_name="created by",
                    ),
                ),
            ],
            options={
                "verbose_name": "word",
                "verbose_name_plural": "words",
            },
        ),
        migrations.CreateModel(
            name="Unit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "released",
                    models.BooleanField(default=False, verbose_name="released"),
                ),
                ("title", models.CharField(max_length=255, verbose_name="unit")),
                (
                    "description",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="description"
                    ),
                ),
                (
                    "icon",
                    models.ImageField(
                        blank=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_images,
                        verbose_name="icon",
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="created at"),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, verbose_name="modified at"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="auth.group",
                        verbose_name="created by",
                    ),
                ),
                (
                    "jobs",
                    models.ManyToManyField(
                        related_name="units", to="cmsv2.job", verbose_name="job"
                    ),
                ),
                (
                    "words",
                    models.ManyToManyField(
                        related_name="units", to="cmsv2.word", verbose_name="word"
                    ),
                ),
            ],
            options={
                "verbose_name": "unit",
                "verbose_name_plural": "units",
            },
        ),
    ]
