# Generated by Django 5.1.2 on 2025-05-24 10:15

from django.db import migrations, models
import django.db.models.deletion
import lunes_cms.cmsv2.models.static


class Migration(migrations.Migration):
    """
    Migration to create the UnitWordRelation model and reestablish the words field in Unit model.

    This migration creates a through model for the many-to-many relationship between Unit and Word,
    allowing additional fields on the relationship.
    """

    dependencies = [
        ("cmsv2", "0007_remove_unit_words"),
    ]

    operations = [
        migrations.CreateModel(
            name="UnitWordRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        blank=True,
                        upload_to=lunes_cms.cmsv2.models.static.convert_umlaute_images,
                        verbose_name="image",
                    ),
                ),
                (
                    "unit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="unit_word_relations",
                        to="cmsv2.unit",
                    ),
                ),
                (
                    "word",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="unit_word_relations",
                        to="cmsv2.word",
                    ),
                ),
            ],
            options={
                "verbose_name": "Unit-Word Relation",
                "verbose_name_plural": "Unit-Word Relations",
                "unique_together": {("unit", "word")},
            },
        ),
        migrations.AddField(
            model_name="unit",
            name="words",
            field=models.ManyToManyField(
                related_name="units",
                through="cmsv2.UnitWordRelation",
                to="cmsv2.word",
                verbose_name="word",
            ),
        ),
    ]
