# Generated by Django 5.1.2 on 2025-05-24 09:37

from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Migration to add audio check status fields to the Word model.

    This migration adds two fields:
    - audio_check_status: For tracking the verification status of audio files
    - audio_checked_identifier: For storing an identifier related to audio verification
    """

    dependencies = [
        ("cmsv2", "0008_unitwordrelation_unit_words"),
    ]

    operations = [
        migrations.AddField(
            model_name="word",
            name="audio_check_status",
            field=models.CharField(
                choices=[("NOT_CHECKED", "Not Checked"), ("CONFIRMED", "Confirmed")],
                default="NOT_CHECKED",
                max_length=20,
                verbose_name="audio check status",
            ),
        ),
        migrations.AddField(
            model_name="word",
            name="audio_checked_identifier",
            field=models.CharField(
                blank=True,
                max_length=255,
                null=True,
                verbose_name="audio checked identifier",
            ),
        ),
    ]
