# Written by Keith Jolley
# Copyright (c) 2024, University of Oxford
# E-mail: keith.jolley@biology.ox.ac.uk
#
# This file is part of BIGSdb Python Toolkit.
#
# BIGSdb Python Toolkit is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# BIGSdb Python Toolkit is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with BIGSdb Python Toolkit. If not,
# see <https://www.gnu.org/licenses/>.

import re

DIRS = {"CONFIG_DIR": "/etc/bigsdb", "DBASE_CONFIG_DIR": "/etc/bigsdb/dbases"}

LOGS = {"BIGSDB_LOG": "/var/log/bigsdb.log", "JOBS_LOG": "/var/log/bigsdb_jobs.log"}

LOCUS_PATTERN = re.compile(r"^(?:l|cn|la)_(.+?)(?:\|\|.+)?$")

CONNECTION_DETAILS = {
    "HOST": "localhost",
    "PORT": 5432,
    "USER": "apache",
    "PASSWORD": "remote",
}

COUNTRIES = {
    "Afghanistan": {"iso2": "AF", "iso3": "AFG", "continent": "Asia"},
    "Åland Islands": {"iso2": "AX", "iso3": "ALA", "continent": "Europe"},
    "Albania": {"iso2": "AL", "iso3": "ALB", "continent": "Europe"},
    "Algeria": {"iso2": "DZ", "iso3": "DZA", "continent": "Africa"},
    "American Samoa": {"iso2": "AS", "iso3": "ASM", "continent": "Oceania"},
    "Andorra": {"iso2": "AD", "iso3": "AND", "continent": "Europe"},
    "Angola": {"iso2": "AO", "iso3": "AGO", "continent": "Africa"},
    "Anguilla": {"iso2": "AI", "iso3": "AIA", "continent": "North America"},
    "Antarctica": {"iso2": "AQ", "iso3": "ATA", "continent": "Antarctica"},
    "Antigua and Barbuda": {"iso2": "AG", "iso3": "ATG", "continent": "North America"},
    "Argentina": {"iso2": "AR", "iso3": "ARG", "continent": "South America"},
    "Armenia": {"iso2": "AM", "iso3": "ARM", "continent": "Asia"},
    "Aruba": {"iso2": "AW", "iso3": "ABW", "continent": "North America"},
    "Australia": {"iso2": "AU", "iso3": "AUS", "continent": "Oceania"},
    "Austria": {"iso2": "AT", "iso3": "AUT", "continent": "Europe"},
    "Azerbaijan": {"iso2": "AZ", "iso3": "AZE", "continent": "Europe"},
    "Bahamas": {"iso2": "BS", "iso3": "BHS", "continent": "North America"},
    "Bahrain": {"iso2": "BH", "iso3": "BHR", "continent": "Asia"},
    "Bangladesh": {"iso2": "BD", "iso3": "BGD", "continent": "Asia"},
    "Barbados": {"iso2": "BB", "iso3": "BRB", "continent": "North America"},
    "Belarus": {"iso2": "BY", "iso3": "BLR", "continent": "Europe"},
    "Belgium": {"iso2": "BE", "iso3": "BEL", "continent": "Europe"},
    "Belize": {"iso2": "BZ", "iso3": "BLZ", "continent": "North America"},
    "Benin": {"iso2": "BJ", "iso3": "BEN", "continent": "Africa"},
    "Bermuda": {"iso2": "BM", "iso3": "BMU", "continent": "North America"},
    "Bhutan": {"iso2": "BT", "iso3": "BTN", "continent": "Asia"},
    "Bolivia": {"iso2": "BO", "iso3": "BOL", "continent": "South America"},
    "Bonaire, Sint Eustatius and Saba": {
        "iso2": "BQ",
        "iso3": "BES",
        "continent": "North America",
    },
    "Bosnia and Herzegovina": {"iso2": "BA", "iso3": "BIH", "continent": "Europe"},
    "Botswana": {"iso2": "BW", "iso3": "BWA", "continent": "Africa"},
    "Bouvet Island": {"iso2": "BV", "iso3": "BVT", "continent": "Antarctica"},
    "Brazil": {"iso2": "BR", "iso3": "BRA", "continent": "South America"},
    "British Indian Ocean Territory": {
        "iso2": "IO",
        "iso3": "IOT",
        "continent": "Asia",
    },
    "British Virgin Islands": {
        "iso2": "VG",
        "iso3": "VGB",
        "continent": "North America",
    },
    "Brunei": {"iso2": "BN", "iso3": "BRN", "continent": "Asia"},
    "Bulgaria": {"iso2": "BG", "iso3": "BGR", "continent": "Europe"},
    "Burkina Faso": {"iso2": "BF", "iso3": "BFA", "continent": "Africa"},
    "Burundi": {"iso2": "BI", "iso3": "BDI", "continent": "Africa"},
    "Cambodia": {"iso2": "KH", "iso3": "KHM", "continent": "Asia"},
    "Cameroon": {"iso2": "CM", "iso3": "CMR", "continent": "Africa"},
    "Canada": {"iso2": "CA", "iso3": "CAN", "continent": "North America"},
    "Cape Verde": {"iso2": "CV", "iso3": "CPV", "continent": "Africa"},
    "Cayman Islands": {"iso2": "KY", "iso3": "CYM", "continent": "North America"},
    "Central African Republic": {"iso2": "CF", "iso3": "CAF", "continent": "Africa"},
    "Chad": {"iso2": "TD", "iso3": "TCD", "continent": "Africa"},
    "Chile": {"iso2": "CL", "iso3": "CHL", "continent": "South America"},
    "China": {"iso2": "CN", "iso3": "CHN", "continent": "Asia"},
    "China [Hong Kong]": {"iso2": "HK", "iso3": "HKG", "continent": "Asia"},
    "China [Macao]": {"iso2": "MO", "iso3": "MAC", "continent": "Asia"},
    "Christmas Island": {"iso2": "CX", "iso3": "CXR", "continent": "Asia"},
    "Cocos (Keeling) Islands": {"iso2": "CC", "iso3": "CCK", "continent": "Asia"},
    "Colombia": {"iso2": "CO", "iso3": "COL", "continent": "South America"},
    "Comoros": {"iso2": "KM", "iso3": "COM", "continent": "Africa"},
    "Congo [DRC]": {"iso2": "CD", "iso3": "COD", "continent": "Africa"},
    "Congo [Republic]": {"iso2": "CG", "iso3": "COG", "continent": "Africa"},
    "Cook Islands": {"iso2": "CK", "iso3": "COK", "continent": "Oceania"},
    "Costa Rica": {"iso2": "CR", "iso3": "CRI", "continent": "North America"},
    "Croatia": {"iso2": "HR", "iso3": "HRV", "continent": "Europe"},
    "Cuba": {"iso2": "CU", "iso3": "CUB", "continent": "North America"},
    "Curaçao": {"iso2": "CW", "iso3": "CUW", "continent": "North America"},
    "Cyprus": {"iso2": "CY", "iso3": "CYP", "continent": "Europe"},
    "Czech Republic": {"iso2": "CZ", "iso3": "CZE", "continent": "Europe"},
    "Denmark": {"iso2": "DK", "iso3": "DNK", "continent": "Europe"},
    "Djibouti": {"iso2": "DJ", "iso3": "DJI", "continent": "Africa"},
    "Dominica": {"iso2": "DM", "iso3": "DMA", "continent": "North America"},
    "Dominican Republic": {"iso2": "DO", "iso3": "DOM", "continent": "North America"},
    "East Timor": {"iso2": "TL", "iso3": "TLS", "continent": "Asia"},
    "Ecuador": {"iso2": "EC", "iso3": "ECU", "continent": "South America"},
    "Egypt": {"iso2": "EG", "iso3": "EGY", "continent": "Africa"},
    "El Salvador": {"iso2": "SV", "iso3": "SLV", "continent": "North America"},
    "Equatorial Guinea": {"iso2": "GQ", "iso3": "GNQ", "continent": "Africa"},
    "Eritrea": {"iso2": "ER", "iso3": "ERI", "continent": "Africa"},
    "Estonia": {"iso2": "EE", "iso3": "EST", "continent": "Europe"},
    "Ethiopia": {"iso2": "ET", "iso3": "ETH", "continent": "Africa"},
    "Falkland Islands (Malvinas)": {
        "iso2": "FK",
        "iso3": "FLK",
        "continent": "South America",
    },
    "Faroe Islands": {"iso2": "FO", "iso3": "FRO", "continent": "Europe"},
    "Fiji": {"iso2": "FJ", "iso3": "FJI", "continent": "Oceania"},
    "Finland": {"iso2": "FI", "iso3": "FIN", "continent": "Europe"},
    "France": {"iso2": "FR", "iso3": "FRA", "continent": "Europe"},
    "French Guiana": {"iso2": "GF", "iso3": "GUF", "continent": "South America"},
    "French Polynesia": {"iso2": "PF", "iso3": "PYF", "continent": "Oceania"},
    "French Southern Territories": {
        "iso2": "TF",
        "iso3": "ATF",
        "continent": "Antarctica",
    },
    "Gabon": {"iso2": "GA", "iso3": "GAB", "continent": "Africa"},
    "Georgia": {"iso2": "GE", "iso3": "GEO", "continent": "Europe"},
    "Germany": {"iso2": "DE", "iso3": "DEU", "continent": "Europe"},
    "Ghana": {"iso2": "GH", "iso3": "GHA", "continent": "Africa"},
    "Gibraltar": {"iso2": "GI", "iso3": "GIB", "continent": "Europe"},
    "Greece": {"iso2": "GR", "iso3": "GRC", "continent": "Europe"},
    "Greenland": {"iso2": "GL", "iso3": "GRL", "continent": "North America"},
    "Grenada": {"iso2": "GD", "iso3": "GRD", "continent": "North America"},
    "Guadeloupe": {"iso2": "GP", "iso3": "GLP", "continent": "North America"},
    "Guam": {"iso2": "GU", "iso3": "GUM", "continent": "Oceania"},
    "Guatemala": {"iso2": "GT", "iso3": "GTM", "continent": "North America"},
    "Guernsey": {"iso2": "GG", "iso3": "GGY", "continent": "Europe"},
    "Guinea": {"iso2": "GN", "iso3": "GIN", "continent": "Africa"},
    "Guinea-Bissau": {"iso2": "GW", "iso3": "GNB", "continent": "Africa"},
    "Guyana": {"iso2": "GY", "iso3": "GUY", "continent": "South America"},
    "Haiti": {"iso2": "HT", "iso3": "HTI", "continent": "North America"},
    "Heard Island and McDonald Islands": {
        "iso2": "HM",
        "iso3": "HMD",
        "continent": "Antarctica",
    },
    "Holy See": {"iso2": "VA", "iso3": "VAT", "continent": "Europe"},
    "Honduras": {"iso2": "HN", "iso3": "HND", "continent": "North America"},
    "Hungary": {"iso2": "HU", "iso3": "HUN", "continent": "Europe"},
    "Iceland": {"iso2": "IS", "iso3": "ISL", "continent": "Europe"},
    "India": {"iso2": "IN", "iso3": "IND", "continent": "Asia"},
    "Indonesia": {"iso2": "ID", "iso3": "IDN", "continent": "Asia"},
    "Iran": {"iso2": "IR", "iso3": "IRN", "continent": "Asia"},
    "Iraq": {"iso2": "IQ", "iso3": "IRQ", "continent": "Asia"},
    "Ireland": {"iso2": "IE", "iso3": "IRL", "continent": "Europe"},
    "Isle of Man": {"iso2": "IM", "iso3": "IMN", "continent": "Europe"},
    "Israel": {"iso2": "IL", "iso3": "ISR", "continent": "Asia"},
    "Italy": {"iso2": "IT", "iso3": "ITA", "continent": "Europe"},
    "Ivory Coast": {"iso2": "CI", "iso3": "CIV", "continent": "Africa"},
    "Jamaica": {"iso2": "JM", "iso3": "JAM", "continent": "North America"},
    "Japan": {"iso2": "JP", "iso3": "JPN", "continent": "Asia"},
    "Jersey": {"iso2": "JE", "iso3": "JEY", "continent": "Europe"},
    "Jordan": {"iso2": "JO", "iso3": "JOR", "continent": "Asia"},
    "Kazakhstan": {"iso2": "KZ", "iso3": "KAZ", "continent": "Asia"},
    "Kenya": {"iso2": "KE", "iso3": "KEN", "continent": "Africa"},
    "Kiribati": {"iso2": "KI", "iso3": "KIR", "continent": "Oceania"},
    "Kuwait": {"iso2": "KW", "iso3": "KWT", "continent": "Asia"},
    "Kyrgyzstan": {"iso2": "KG", "iso3": "KGZ", "continent": "Asia"},
    "Laos": {"iso2": "LA", "iso3": "LAO", "continent": "Asia"},
    "Latvia": {"iso2": "LV", "iso3": "LVA", "continent": "Europe"},
    "Lebanon": {"iso2": "LB", "iso3": "LBN", "continent": "Asia"},
    "Lesotho": {"iso2": "LS", "iso3": "LSO", "continent": "Africa"},
    "Liberia": {"iso2": "LR", "iso3": "LBR", "continent": "Africa"},
    "Libya": {"iso2": "LY", "iso3": "LBY", "continent": "Africa"},
    "Liechtenstein": {"iso2": "LI", "iso3": "LIE", "continent": "Europe"},
    "Lithuania": {"iso2": "LT", "iso3": "LTU", "continent": "Europe"},
    "Luxembourg": {"iso2": "LU", "iso3": "LUX", "continent": "Europe"},
    "Madagascar": {"iso2": "MG", "iso3": "MDG", "continent": "Africa"},
    "Malawi": {"iso2": "MW", "iso3": "MWI", "continent": "Africa"},
    "Malaysia": {"iso2": "MY", "iso3": "MYS", "continent": "Asia"},
    "Maldives": {"iso2": "MV", "iso3": "MDV", "continent": "Asia"},
    "Mali": {"iso2": "ML", "iso3": "MLI", "continent": "Africa"},
    "Malta": {"iso2": "MT", "iso3": "MLT", "continent": "Europe"},
    "Marshall Islands": {"iso2": "MH", "iso3": "MHL", "continent": "Oceania"},
    "Martinique": {"iso2": "MQ", "iso3": "MTQ", "continent": "North America"},
    "Mauritania": {"iso2": "MR", "iso3": "MRT", "continent": "Africa"},
    "Mauritius": {"iso2": "MU", "iso3": "MUS", "continent": "Africa"},
    "Mayotte": {"iso2": "YT", "iso3": "MYT", "continent": "Africa"},
    "Mexico": {"iso2": "MX", "iso3": "MEX", "continent": "North America"},
    "Micronesia": {"iso2": "FM", "iso3": "FSM", "continent": "Oceania"},
    "Moldova": {"iso2": "MD", "iso3": "MDA", "continent": "Europe"},
    "Monaco": {"iso2": "MC", "iso3": "MCO", "continent": "Europe"},
    "Mongolia": {"iso2": "MN", "iso3": "MNG", "continent": "Asia"},
    "Montenegro": {"iso2": "ME", "iso3": "MNE", "continent": "Europe"},
    "Montserrat": {"iso2": "MS", "iso3": "MSR", "continent": "North America"},
    "Morocco": {"iso2": "MA", "iso3": "MAR", "continent": "Africa"},
    "Mozambique": {"iso2": "MZ", "iso3": "MOZ", "continent": "Africa"},
    "Myanmar": {"iso2": "MM", "iso3": "MMR", "continent": "Asia"},
    "Namibia": {"iso2": "NA", "iso3": "NAM", "continent": "Africa"},
    "Nauru": {"iso2": "NR", "iso3": "NRU", "continent": "Oceania"},
    "Nepal": {"iso2": "NP", "iso3": "NPL", "continent": "Asia"},
    "New Caledonia": {"iso2": "NC", "iso3": "NCL", "continent": "Oceania"},
    "New Zealand": {"iso2": "NZ", "iso3": "NZL", "continent": "Oceania"},
    "Nicaragua": {"iso2": "NI", "iso3": "NIC", "continent": "North America"},
    "Niger": {"iso2": "NE", "iso3": "NER", "continent": "Africa"},
    "Nigeria": {"iso2": "NG", "iso3": "NGA", "continent": "Africa"},
    "Niue": {"iso2": "NU", "iso3": "NIU", "continent": "Oceania"},
    "Norfolk Island": {"iso2": "NF", "iso3": "NFK", "continent": "Oceania"},
    "North Korea": {"iso2": "KP", "iso3": "PRK", "continent": "Asia"},
    "North Macedonia": {"iso2": "MK", "iso3": "MKD", "continent": "Europe"},
    "Northern Mariana Islands": {"iso2": "MP", "iso3": "MNP", "continent": "Oceania"},
    "Norway": {"iso2": "NO", "iso3": "NOR", "continent": "Europe"},
    "Oman": {"iso2": "OM", "iso3": "OMN", "continent": "Asia"},
    "Pakistan": {"iso2": "PK", "iso3": "PAK", "continent": "Asia"},
    "Palau": {"iso2": "PW", "iso3": "PLW", "continent": "Oceania"},
    "Palestinian territories": {"iso2": "PS", "iso3": "PSE", "continent": "Asia"},
    "Panama": {"iso2": "PA", "iso3": "PAN", "continent": "North America"},
    "Papua New Guinea": {"iso2": "PG", "iso3": "PNG", "continent": "Oceania"},
    "Paraguay": {"iso2": "PY", "iso3": "PRY", "continent": "South America"},
    "Peru": {"iso2": "PE", "iso3": "PER", "continent": "South America"},
    "Philippines": {"iso2": "PH", "iso3": "PHL", "continent": "Asia"},
    "Pitcairn": {"iso2": "PN", "iso3": "PCN", "continent": "Oceania"},
    "Poland": {"iso2": "PL", "iso3": "POL", "continent": "Europe"},
    "Portugal": {"iso2": "PT", "iso3": "PRT", "continent": "Europe"},
    "Puerto Rico": {"iso2": "PR", "iso3": "PRI", "continent": "North America"},
    "Qatar": {"iso2": "QA", "iso3": "QAT", "continent": "Asia"},
    "Réunion": {"iso2": "RE", "iso3": "REU", "continent": "Africa"},
    "Romania": {"iso2": "RO", "iso3": "ROU", "continent": "Europe"},
    "Russia": {"iso2": "RU", "iso3": "RUS", "continent": "Asia"},
    "Russia [Asia]": {"iso2": "RU", "iso3": "RUS", "continent": "Asia"},
    "Russia [Europe]": {"iso2": "RU", "iso3": "RUS", "continent": "Europe"},
    "Rwanda": {"iso2": "RW", "iso3": "RWA", "continent": "Africa"},
    "Saint Barthélemy": {"iso2": "BL", "iso3": "BLM", "continent": "North America"},
    "Saint Helena": {"iso2": "SH", "iso3": "SHN", "continent": "Africa"},
    "Saint Kitts and Nevis": {
        "iso2": "KN",
        "iso3": "KNA",
        "continent": "North America",
    },
    "Saint Lucia": {"iso2": "LC", "iso3": "LCA", "continent": "North America"},
    "Saint Martin (French Part)": {
        "iso2": "MF",
        "iso3": "MAF",
        "continent": "North America",
    },
    "Saint Pierre and Miquelon": {
        "iso2": "PM",
        "iso3": "SPM",
        "continent": "North America",
    },
    "Saint Vincent and the Grenadines": {
        "iso2": "VC",
        "iso3": "VCT",
        "continent": "North America",
    },
    "Samoa": {"iso2": "WS", "iso3": "WSM", "continent": "Oceania"},
    "San Marino": {"iso2": "SM", "iso3": "SMR", "continent": "Europe"},
    "São Tomé and Príncipe": {"iso2": "ST", "iso3": "STP", "continent": "Africa"},
    "Sark": {"iso2": "CQ", "iso3": "", "continent": "Europe"},
    "Saudi Arabia": {"iso2": "SA", "iso3": "SAU", "continent": "Asia"},
    "Senegal": {"iso2": "SN", "iso3": "SEN", "continent": "Africa"},
    "Serbia": {"iso2": "RS", "iso3": "SRB", "continent": "Europe"},
    "Seychelles": {"iso2": "SC", "iso3": "SYC", "continent": "Africa"},
    "Sierra Leone": {"iso2": "SL", "iso3": "SLE", "continent": "Africa"},
    "Singapore": {"iso2": "SG", "iso3": "SGP", "continent": "Asia"},
    "Sint Maarten (Dutch part)": {
        "iso2": "SX",
        "iso3": "SXM",
        "continent": "North America",
    },
    "Slovakia": {"iso2": "SK", "iso3": "SVK", "continent": "Europe"},
    "Slovenia": {"iso2": "SI", "iso3": "SVN", "continent": "Europe"},
    "Solomon Islands": {"iso2": "SB", "iso3": "SLB", "continent": "Oceania"},
    "Somalia": {"iso2": "SO", "iso3": "SOM", "continent": "Africa"},
    "South Africa": {"iso2": "ZA", "iso3": "ZAF", "continent": "Africa"},
    "South Georgia and the South Sandwich Islands": {
        "iso2": "GS",
        "iso3": "SGS",
        "continent": "Antarctica",
    },
    "South Korea": {"iso2": "KR", "iso3": "KOR", "continent": "Asia"},
    "South Sudan": {"iso2": "SS", "iso3": "SSD", "continent": "Africa"},
    "Spain": {"iso2": "ES", "iso3": "ESP", "continent": "Europe"},
    "Sri Lanka": {"iso2": "LK", "iso3": "LKA", "continent": "Asia"},
    "Sudan": {"iso2": "SD", "iso3": "SDN", "continent": "Africa"},
    "Suriname": {"iso2": "SR", "iso3": "SUR", "continent": "South America"},
    "Svalbard and Jan Mayen Islands": {
        "iso2": "SJ",
        "iso3": "SJM",
        "continent": "Europe",
    },
    "Swaziland": {"iso2": "SZ", "iso3": "SWZ", "continent": "Africa"},
    "Sweden": {"iso2": "SE", "iso3": "SWE", "continent": "Europe"},
    "Switzerland": {"iso2": "CH", "iso3": "CHE", "continent": "Europe"},
    "Syria": {"iso2": "SY", "iso3": "SYR", "continent": "Asia"},
    "Taiwan": {"iso2": "TW", "iso3": "TWN", "continent": "Asia"},
    "Tajikistan": {"iso2": "TJ", "iso3": "TJK", "continent": "Asia"},
    "Tanzania": {"iso2": "TZ", "iso3": "TZA", "continent": "Africa"},
    "Thailand": {"iso2": "TH", "iso3": "THA", "continent": "Asia"},
    "The Gambia": {"iso2": "GM", "iso3": "GMB", "continent": "Africa"},
    "The Netherlands": {"iso2": "NL", "iso3": "NLD", "continent": "Europe"},
    "Togo": {"iso2": "TG", "iso3": "TGO", "continent": "Africa"},
    "Tokelau": {"iso2": "TK", "iso3": "TKL", "continent": "Oceania"},
    "Tonga": {"iso2": "TO", "iso3": "TON", "continent": "Oceania"},
    "Trinidad and Tobago": {"iso2": "TT", "iso3": "TTO", "continent": "North America"},
    "Tunisia": {"iso2": "TN", "iso3": "TUN", "continent": "Africa"},
    "Turkey": {"iso2": "TR", "iso3": "TUR", "continent": "Asia"},
    "Turkmenistan": {"iso2": "TM", "iso3": "TKM", "continent": "Asia"},
    "Turks and Caicos Islands": {
        "iso2": "TC",
        "iso3": "TCA",
        "continent": "North America",
    },
    "Tuvalu": {"iso2": "TV", "iso3": "TUV", "continent": "Oceania"},
    "Uganda": {"iso2": "UG", "iso3": "UGA", "continent": "Africa"},
    "UK": {"iso2": "GB", "iso3": "GBR", "continent": "Europe"},
    "UK [England]": {"iso2": "GB", "iso3": "GBR", "continent": "Europe"},
    "UK [Northern Ireland]": {"iso2": "GB", "iso3": "GBR", "continent": "Europe"},
    "UK [Scotland]": {"iso2": "GB", "iso3": "GBR", "continent": "Europe"},
    "UK [Wales]": {"iso2": "GB", "iso3": "GBR", "continent": "Europe"},
    "Ukraine": {"iso2": "UA", "iso3": "UKR", "continent": "Europe"},
    "United Arab Emirates": {"iso2": "AE", "iso3": "ARE", "continent": "Asia"},
    "Uruguay": {"iso2": "UY", "iso3": "URY", "continent": "South America"},
    "US Minor Outlying Islands": {"iso2": "UM", "iso3": "UMI", "continent": "Oceania"},
    "US Virgin Islands": {"iso2": "VI", "iso3": "VIR", "continent": "North America"},
    "USA": {"iso2": "US", "iso3": "USA", "continent": "North America"},
    "Uzbekistan": {"iso2": "UZ", "iso3": "UZB", "continent": "Asia"},
    "Vanuatu": {"iso2": "VU", "iso3": "VUT", "continent": "Oceania"},
    "Venezuela": {"iso2": "VE", "iso3": "VEN", "continent": "South America"},
    "Vietnam": {"iso2": "VN", "iso3": "VNM", "continent": "Asia"},
    "Wallis and Futuna Islands": {"iso2": "WF", "iso3": "WLF", "continent": "Oceania"},
    "Western Sahara": {"iso2": "EH", "iso3": "ESH", "continent": "Africa"},
    "Yemen": {"iso2": "YE", "iso3": "YEM", "continent": "Asia"},
    "Zambia": {"iso2": "ZM", "iso3": "ZMB", "continent": "Africa"},
    "Zimbabwe": {"iso2": "ZW", "iso3": "ZWE", "continent": "Africa"},
}
