"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// functions/src/api-docs.lambda.ts
var api_docs_lambda_exports = {};
__export(api_docs_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(api_docs_lambda_exports);
var import_aws_sdk = require("aws-sdk");

// functions/src/open-api-spec-patcher.ts
var OpenApiSpecPatcher = class {
  constructor(options) {
    this.options = { pathsToRemove: [], patchServerSlashPrefixes: true, ...options || {} };
  }
  patchJson(spec) {
    const obj = JSON.parse(spec);
    this.patch(obj);
    return JSON.stringify(obj);
  }
  patch(spec) {
    if (true === this.options.patchServerSlashPrefixes) {
      this.patchServerVariableSlashPrefixes(spec);
    }
    this.options.pathsToRemove.forEach((e) => {
      this.removeProperty(spec.paths || {}, e);
    });
    return spec;
  }
  patchServerVariableSlashPrefixes(spec) {
    if (!Array.isArray(spec.servers || null))
      return spec;
    spec.servers = spec.servers.map((e) => {
      if (!e.variables || !e.url)
        return e;
      return { ...e, variables: this.patchSrvVars(e.variables, e.url) };
    });
    return spec;
  }
  removeProperty(spec, removeKey) {
    if (spec.hasOwnProperty(removeKey))
      delete spec[removeKey];
    return spec;
  }
  hasPrefixedKey(url, v) {
    return null !== url.match(new RegExp(`\\/\\{${v}\\}`, "g"));
  }
  removePrefix(s) {
    return s.charAt(0) === "/" ? s.substring(1) : s;
  }
  patchSrvVars(vars, url) {
    return Object.entries(vars).reduce((r, [k, v]) => {
      r[k] = v;
      if (this.hasPrefixedKey(url, k)) {
        if (r[k].default)
          r[k].default = this.removePrefix(r[k].default);
        if (Array.isArray(r[k].enum))
          r[k].enum = r[k].enum.map((i) => this.removePrefix(i));
      }
      return r;
    }, {});
  }
};

// functions/src/api-docs.lambda.ts
var apiGateway;
var patcher = new OpenApiSpecPatcher({ pathsToRemove: ["/api-docs.json", "/api-docs/{proxy+}", "/api-docs"] });
async function handler(request) {
  apiGateway = new import_aws_sdk.APIGateway();
  try {
    const spec = await apiGateway.getExport({
      restApiId: request.requestContext.apiId,
      stageName: request.requestContext.stage,
      exportType: "oas30",
      parameters: {},
      accepts: "application/json"
    }).promise();
    const patchedSpec = patcher.patchJson(spec.body.toString());
    return {
      statusCode: 200,
      headers: { "Content-Type": "application/json", "Content-Disposition": "inline" },
      body: patchedSpec,
      isBase64Encoded: false
    };
  } catch (e) {
    const error = e;
    console.log(error);
    return {
      statusCode: 500,
      headers: { "Content-Type": "application/problem+json" },
      body: JSON.stringify({
        type: "about:blank",
        title: error.code,
        status: 500,
        description: error.message
      }),
      isBase64Encoded: false
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
