"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const swagger_ui_1 = require("./swagger-ui");
// yarn cdk deploy --app 'npx ts-node -P tsconfig.dev.json --prefer-ts-exts ./src/integ.default.ts'
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, "SwaggerUI");
const restApi = new apigateway.RestApi(stack, "RestApi");
new swagger_ui_1.SwaggerUi(stack, "SwaggerUI", { resource: restApi.root });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkNBQXlDO0FBQ3pDLHlEQUF5RDtBQUN6RCw2Q0FBeUM7QUFFekMsbUdBQW1HO0FBRW5HLE1BQU0sR0FBRyxHQUFHLElBQUksaUJBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksbUJBQUssQ0FBQyxHQUFHLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFFMUMsTUFBTSxPQUFPLEdBQUcsSUFBSSxVQUFVLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztBQUN6RCxJQUFJLHNCQUFTLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRSxFQUFFLFFBQVEsRUFBRSxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCAqIGFzIGFwaWdhdGV3YXkgZnJvbSBcImF3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5XCI7XG5pbXBvcnQgeyBTd2FnZ2VyVWkgfSBmcm9tIFwiLi9zd2FnZ2VyLXVpXCI7XG5cbi8vIHlhcm4gY2RrIGRlcGxveSAtLWFwcCAnbnB4IHRzLW5vZGUgLVAgdHNjb25maWcuZGV2Lmpzb24gLS1wcmVmZXItdHMtZXh0cyAuL3NyYy9pbnRlZy5kZWZhdWx0LnRzJ1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsIFwiU3dhZ2dlclVJXCIpO1xuXG5jb25zdCByZXN0QXBpID0gbmV3IGFwaWdhdGV3YXkuUmVzdEFwaShzdGFjaywgXCJSZXN0QXBpXCIpO1xubmV3IFN3YWdnZXJVaShzdGFjaywgXCJTd2FnZ2VyVUlcIiwgeyByZXNvdXJjZTogcmVzdEFwaS5yb290IH0pO1xuIl19