"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTags = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class CreateTags extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const { resourceIds, tags } = props;
        const removalPolicy = (_b = props.removalPolicy) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.RemovalPolicy.RETAIN;
        new custom_resources_1.AwsCustomResource(this, "CreateTags", {
            onCreate: {
                service: "EC2",
                action: "createTags",
                region: aws_cdk_lib_1.Stack.of(this).region,
                parameters: {
                    Resources: resourceIds,
                    Tags: tags.map((tag) => {
                        return { Key: tag.key, Value: tag.value };
                    }),
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(this.makeUniqueId(resourceIds)),
            },
            onDelete: removalPolicy != aws_cdk_lib_1.RemovalPolicy.DESTROY
                ? undefined
                : {
                    service: "EC2",
                    action: "createTags",
                    region: aws_cdk_lib_1.Stack.of(this).region,
                    parameters: {
                        Resources: resourceIds,
                        Tags: tags.map((tag) => {
                            return { Key: tag.key, Value: tag.value };
                        }),
                    },
                    physicalResourceId: custom_resources_1.PhysicalResourceId.of(this.makeUniqueId(resourceIds)),
                },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
    makeUniqueId(resourceIds) {
        const human = resourceIds
            .map((s) => {
            return s.replace(/[^A-Za-z0-9]/g, "");
        })
            .join("")
            .slice(0, 240);
        const md5 = crypto.createHash("md5").update(resourceIds.join("")).digest("hex");
        const hash = md5.slice(0, 8).toUpperCase();
        return human + hash;
    }
}
exports.CreateTags = CreateTags;
_a = JSII_RTTI_SYMBOL_1;
CreateTags[_a] = { fqn: "@pepperize/cdk-vpc.CreateTags", version: "0.0.94" };
//# sourceMappingURL=data:application/json;base64,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