---
#template: examples.html
hide:
   - navigation
#   - toc
   - footer
---

<style>
.md-main .md-main__inner.md-grid {
    flex-direction: row-reverse;
}
</style>

## Single-node training

<div class="tx-landing__highlights_grid">
    <a href="/examples/single-node-training/trl"
       class="feature-cell">
        <h3>
            TRL
        </h3>

        <p>
            Fine-tune Llama 3.1 8B on a custom dataset using TRL.
        </p>
    </a>

    <a href="/examples/single-node-training/axolotl"
       class="feature-cell">
        <h3>
            Axolotl
        </h3>

        <p>
            Fine-tune Llama 4 on a custom dataset using Axolotl.
        </p>
    </a>
</div>

## Distributed training

<div class="tx-landing__highlights_grid">
    <a href="/examples/distributed-training/trl"
       class="feature-cell sky">
        <h3>
            TRL
        </h3>

        <p>
            Fine-tune LLM on multiple nodes
            with TRL, Accelerate, and Deepspeed.
        </p>
    </a>
    <a href="/examples/distributed-training/axolotl"
       class="feature-cell sky">
        <h3>
            Axolotl
        </h3>

        <p>
            Fine-tune LLM on multiple nodes
            with Axolotl.
        </p>
    </a>
    <a href="/examples/distributed-training/ray-ragen"
       class="feature-cell sky">
        <h3>
            Ray+RAGEN
        </h3>

        <p>
            Fine-tune an agent on multiple nodes
            with RAGEN, verl, and Ray.
        </p>
    </a>
</div>


## Clusters

<div class="tx-landing__highlights_grid">
    <a href="/examples/clusters/nccl-tests"
       class="feature-cell sky">
        <h3>
            NCCL tests
        </h3>

        <p>
            Run multi-node NCCL tests with MPI
        </p>
    </a>
    <a href="/examples/clusters/rccl-tests"
       class="feature-cell sky">
        <h3>
            RCCL tests
        </h3>

        <p>
            Run multi-node RCCL tests with MPI
        </p>
    </a>
    <a href="/examples/clusters/a3mega"
       class="feature-cell sky">
        <h3>
            GCP A3 Mega
        </h3>

        <p>
            Set up GCP A3 Mega clusters with optimized networking
        </p>
    </a>
    <a href="/examples/clusters/a3high"
       class="feature-cell sky">
        <h3>
            GCP A3 High
        </h3>

        <p>
            Set up GCP A3 High clusters with optimized networking
        </p>
    </a>
        <a href="/examples/clusters/efa"
       class="feature-cell sky">
        <h3>
            AWS EFA
        </h3>

        <p>
            Set up AWS EFA clusters with optimized networking
        </p>
    </a>
</div>

## Inference

<div class="tx-landing__highlights_grid">
    <a href="/examples/inference/sglang" 
       class="feature-cell">
       <h3>
           SGLang
       </h3>
       <p>
           Deploy DeepSeek distilled models with SGLang
      </p>
    </a>
    <a href="/examples/inference/vllm" 
       class="feature-cell">
       <h3>
           vLLM
       </h3>
       <p>
            Deploy Llama 3.1 with vLLM
        </p>
    </a>
    <a href="/examples/inference/tgi" 
       class="feature-cell">
       <h3>
           TGI
       </h3>
       <p>
            Deploy Llama 4 with TGI
        </p>
    </a>
    <a href="/examples/inference/nim" 
       class="feature-cell">
       <h3>
           NIM
       </h3>
       <p>
            Deploy a DeepSeek distilled model with NIM
        </p>
    </a>
    <a href="/examples/inference/trtllm"
       class="feature-cell">
       <h3>
           TensorRT-LLM
       </h3>
       <p>
            Deploy DeepSeek models with TensorRT-LLM
        </p>
    </a>
</div>

## Accelerators

<div class="tx-landing__highlights_grid">
    <a href="/examples/accelerators/amd"
       class="feature-cell sky">
        <h3>
            AMD
        </h3>

        <p>
            Deploy and fine-tune LLMs on AMD
        </p>
    </a>

    <a href="/examples/accelerators/tpu"
       class="feature-cell sky">
        <h3>
            TPU
        </h3>

        <p>
            Deploy and fine-tune LLMs on TPU
        </p>
    </a>

    <a href="/examples/accelerators/intel"
       class="feature-cell sky">
        <h3>
            Intel Gaudi
        </h3>

        <p>
            Deploy and fine-tune LLMs on Intel Gaudi
        </p>
    </a>

    <a href="/examples/accelerators/tenstorrent"
       class="feature-cell sky">
        <h3>
            Tenstorrent
        </h3>

        <p>
            Deploy and fine-tune LLMs on Tenstorrent
        </p>
    </a>
</div>

<!-- ## Misc

<div class="tx-landing__highlights_grid">
    <a href="/examples/misc/docker-compose"
       class="feature-cell sky">
        <h3>
            Docker Compose
        </h3>

        <p>
            Use Docker and Docker Compose inside runs
        </p>
    </a>
</div> -->
