"""Add VULTR to backendtype enum

Revision ID: 065588ec72b8
Revises: 91a12fff6c76
Create Date: 2024-12-24 12:56:57.018776

"""

from alembic import op
from alembic_postgresql_enum import TableReference

# revision identifiers, used by Alembic.
revision = "065588ec72b8"
down_revision = "91a12fff6c76"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Add the new enum value "VULTR" to the backendtype enum
    op.sync_enum_values(
        "public",
        "backendtype",
        [
            "AWS",
            "AZURE",
            "CUDO",
            "DATACRUNCH",
            "DSTACK",
            "GCP",
            "KUBERNETES",
            "LAMBDA",
            "LOCAL",
            "REMOTE",
            "NEBIUS",
            "OCI",
            "RUNPOD",
            "TENSORDOCK",
            "VASTAI",
            "VULTR",  # New value
        ],
        [
            TableReference(table_schema="public", table_name="instances", column_name="backend"),
            TableReference(table_schema="public", table_name="backends", column_name="type"),
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Remove the new enum value "VULTR" from the backendtype enum
    op.sync_enum_values(
        "public",
        "backendtype",
        [
            "AWS",
            "AZURE",
            "CUDO",
            "DATACRUNCH",
            "DSTACK",
            "GCP",
            "KUBERNETES",
            "LAMBDA",
            "LOCAL",
            "REMOTE",
            "NEBIUS",
            "OCI",
            "RUNPOD",
            "TENSORDOCK",
            "VASTAI",
        ],  # Without "VULTR"
        [
            TableReference(table_schema="public", table_name="instances", column_name="backend"),
            TableReference(table_schema="public", table_name="backends", column_name="type"),
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###
