"""Remove nullable fields

Revision ID: 112753bc17dd
Revises: d0bb68e48b9f
Create Date: 2023-11-01 11:35:02.110752

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "112753bc17dd"
down_revision = "d0bb68e48b9f"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("projects", schema=None) as batch_op:
        batch_op.alter_column("owner_id", existing_type=sa.CHAR(length=32), nullable=False)
        batch_op.drop_constraint("fk_projects_owner_id_users", type_="foreignkey")
        batch_op.create_foreign_key(
            batch_op.f("fk_projects_owner_id_users"),
            "users",
            ["owner_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("users", schema=None) as batch_op:
        batch_op.alter_column("projects_quota", existing_type=sa.INTEGER(), nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("users", schema=None) as batch_op:
        batch_op.alter_column("projects_quota", existing_type=sa.INTEGER(), nullable=True)

    with op.batch_alter_table("projects", schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f("fk_projects_owner_id_users"), type_="foreignkey")
        batch_op.create_foreign_key(
            "fk_projects_owner_id_users", "users", ["owner_id"], ["id"], ondelete="SET NULL"
        )
        batch_op.alter_column("owner_id", existing_type=sa.CHAR(length=32), nullable=True)

    # ### end Alembic commands ###
