"""Add JobModel.disconnected_at

Revision ID: 20166748b60c
Revises: 6c1a9d6530ee
Create Date: 2025-05-13 16:24:32.496578

"""

import sqlalchemy as sa
from alembic import op
from alembic_postgresql_enum import TableReference

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "20166748b60c"
down_revision = "6c1a9d6530ee"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "disconnected_at", dstack._internal.server.models.NaiveDateTime(), nullable=True
            )
        )

    op.sync_enum_values(
        enum_schema="public",
        enum_name="jobterminationreason",
        new_values=[
            "FAILED_TO_START_DUE_TO_NO_CAPACITY",
            "INTERRUPTED_BY_NO_CAPACITY",
            "INSTANCE_UNREACHABLE",
            "WAITING_INSTANCE_LIMIT_EXCEEDED",
            "WAITING_RUNNER_LIMIT_EXCEEDED",
            "TERMINATED_BY_USER",
            "VOLUME_ERROR",
            "GATEWAY_ERROR",
            "SCALED_DOWN",
            "DONE_BY_RUNNER",
            "ABORTED_BY_USER",
            "TERMINATED_BY_SERVER",
            "INACTIVITY_DURATION_EXCEEDED",
            "TERMINATED_DUE_TO_UTILIZATION_POLICY",
            "CONTAINER_EXITED_WITH_ERROR",
            "PORTS_BINDING_FAILED",
            "CREATING_CONTAINER_ERROR",
            "EXECUTOR_ERROR",
            "MAX_DURATION_EXCEEDED",
        ],
        affected_columns=[
            TableReference(
                table_schema="public", table_name="jobs", column_name="termination_reason"
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="jobterminationreason",
        new_values=[
            "FAILED_TO_START_DUE_TO_NO_CAPACITY",
            "INTERRUPTED_BY_NO_CAPACITY",
            "WAITING_INSTANCE_LIMIT_EXCEEDED",
            "WAITING_RUNNER_LIMIT_EXCEEDED",
            "TERMINATED_BY_USER",
            "VOLUME_ERROR",
            "GATEWAY_ERROR",
            "SCALED_DOWN",
            "DONE_BY_RUNNER",
            "ABORTED_BY_USER",
            "TERMINATED_BY_SERVER",
            "INACTIVITY_DURATION_EXCEEDED",
            "TERMINATED_DUE_TO_UTILIZATION_POLICY",
            "CONTAINER_EXITED_WITH_ERROR",
            "PORTS_BINDING_FAILED",
            "CREATING_CONTAINER_ERROR",
            "EXECUTOR_ERROR",
            "MAX_DURATION_EXCEEDED",
        ],
        affected_columns=[
            TableReference(
                table_schema="public", table_name="jobs", column_name="termination_reason"
            )
        ],
        enum_values_to_rename=[],
    )
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_column("disconnected_at")

    # ### end Alembic commands ###
