"""Add probes

Revision ID: 25479f540245
Revises: 50dd7ea98639
Create Date: 2025-08-03 19:51:07.722217

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "25479f540245"
down_revision = "50dd7ea98639"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "probes",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column("job_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("probe_num", sa.Integer(), nullable=False),
        sa.Column("due", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column("success_streak", sa.BigInteger(), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["job_id"], ["jobs.id"], name=op.f("fk_probes_job_id_jobs")),
        sa.PrimaryKeyConstraint("id", "job_id", name=op.f("pk_probes")),
        sa.UniqueConstraint("job_id", "probe_num", name="uq_probes_job_id_probe_num"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("probes")
    # ### end Alembic commands ###
