"""Add ProjectModel.is_public

Revision ID: 35f732ee4cf5
Revises: bca2fdf130bf
Create Date: 2025-06-06 13:04:02.912032

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "35f732ee4cf5"
down_revision = "bca2fdf130bf"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Add is_public column as nullable first
    with op.batch_alter_table("projects", schema=None) as batch_op:
        batch_op.add_column(sa.Column("is_public", sa.Boolean(), nullable=True))

    # Set is_public to False for existing projects
    op.execute(sa.sql.text("UPDATE projects SET is_public = FALSE"))

    # Make is_public non-nullable with default value
    with op.batch_alter_table("projects", schema=None) as batch_op:
        batch_op.alter_column("is_public", nullable=False, server_default=sa.false())
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Remove is_public column
    with op.batch_alter_table("projects", schema=None) as batch_op:
        batch_op.drop_column("is_public")
    # ### end Alembic commands ###
