"""Index status columns

Revision ID: 50dd7ea98639
Revises: ec02a26a256c
Create Date: 2025-07-25 10:36:25.127923

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "50dd7ea98639"
down_revision = "ec02a26a256c"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_runs_status"), ["status"], unique=False)

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_jobs_status"), ["status"], unique=False)

    with op.batch_alter_table("fleets", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_fleets_status"), ["status"], unique=False)

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_instances_status"), ["status"], unique=False)

    with op.batch_alter_table("volumes", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_volumes_status"), ["status"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_runs_status"))

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_jobs_status"))

    with op.batch_alter_table("fleets", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_fleets_status"))

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_instances_status"))

    with op.batch_alter_table("volumes", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_volumes_status"))

    # ### end Alembic commands ###
