"""Change InstanceModel for asynchronous create_instance

Revision ID: 555138b1f77f
Revises: 4ae1a5b0e7f1
Create Date: 2024-03-12 17:17:39.669661

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "555138b1f77f"
down_revision = "4ae1a5b0e7f1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.add_column(sa.Column("profile", sa.Text(), nullable=True))
        batch_op.add_column(sa.Column("requirements", sa.String(length=10000), nullable=True))
        batch_op.add_column(sa.Column("instance_configuration", sa.Text(), nullable=True))
        batch_op.add_column(sa.Column("retry_policy", sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column("retry_policy_duration", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("last_retry_at", sa.DateTime(), nullable=True))
        batch_op.alter_column("backend", existing_type=sa.VARCHAR(length=10), nullable=True)
        batch_op.alter_column("offer", existing_type=sa.VARCHAR(length=4000), nullable=True)
        batch_op.alter_column("region", existing_type=sa.VARCHAR(length=2000), nullable=True)
        batch_op.alter_column("price", existing_type=sa.FLOAT(), nullable=True)
        batch_op.alter_column(
            "job_provisioning_data", existing_type=sa.VARCHAR(length=4000), nullable=True
        )

    # Set the default value for the retry_policy
    op.execute(sa.sql.text("UPDATE instances SET retry_policy = FALSE"))

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column("retry_policy", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "job_provisioning_data", existing_type=sa.VARCHAR(length=4000), nullable=False
        )
        batch_op.alter_column("price", existing_type=sa.FLOAT(), nullable=False)
        batch_op.alter_column("region", existing_type=sa.VARCHAR(length=2000), nullable=False)
        batch_op.alter_column("offer", existing_type=sa.VARCHAR(length=4000), nullable=False)
        batch_op.alter_column("backend", existing_type=sa.VARCHAR(length=10), nullable=False)
        batch_op.drop_column("last_retry_at")
        batch_op.drop_column("retry_policy_duration")
        batch_op.drop_column("retry_policy")
        batch_op.drop_column("instance_configuration")
        batch_op.drop_column("requirements")
        batch_op.drop_column("profile")

    # ### end Alembic commands ###
