"""Add JobPrometheusMetrics

Revision ID: 60e444118b6d
Revises: a751ef183f27
Create Date: 2025-02-21 10:59:26.339353

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "60e444118b6d"
down_revision = "a751ef183f27"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "job_prometheus_metrics",
        sa.Column("job_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("collected_at", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column("text", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["job_id"], ["jobs.id"], name=op.f("fk_job_prometheus_metrics_job_id_jobs")
        ),
        sa.PrimaryKeyConstraint("job_id", name=op.f("pk_job_prometheus_metrics")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("job_prometheus_metrics")
    # ### end Alembic commands ###
