"""Add JobTerminationReason.INACTIVITY_DURATION_EXCEEDED

Revision ID: 63c3f19cb184
Revises: 1338b788b612
Create Date: 2025-02-11 22:30:47.289393

"""

from alembic import op
from alembic_postgresql_enum import TableReference

# revision identifiers, used by Alembic.
revision = "63c3f19cb184"
down_revision = "1338b788b612"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="jobterminationreason",
        new_values=[
            "FAILED_TO_START_DUE_TO_NO_CAPACITY",
            "INTERRUPTED_BY_NO_CAPACITY",
            "WAITING_INSTANCE_LIMIT_EXCEEDED",
            "WAITING_RUNNER_LIMIT_EXCEEDED",
            "TERMINATED_BY_USER",
            "VOLUME_ERROR",
            "GATEWAY_ERROR",
            "SCALED_DOWN",
            "DONE_BY_RUNNER",
            "ABORTED_BY_USER",
            "TERMINATED_BY_SERVER",
            "INACTIVITY_DURATION_EXCEEDED",
            "CONTAINER_EXITED_WITH_ERROR",
            "PORTS_BINDING_FAILED",
            "CREATING_CONTAINER_ERROR",
            "EXECUTOR_ERROR",
            "MAX_DURATION_EXCEEDED",
        ],
        affected_columns=[
            TableReference(
                table_schema="public", table_name="jobs", column_name="termination_reason"
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.sync_enum_values(
        enum_schema="public",
        enum_name="jobterminationreason",
        new_values=[
            "FAILED_TO_START_DUE_TO_NO_CAPACITY",
            "INTERRUPTED_BY_NO_CAPACITY",
            "WAITING_INSTANCE_LIMIT_EXCEEDED",
            "WAITING_RUNNER_LIMIT_EXCEEDED",
            "TERMINATED_BY_USER",
            "VOLUME_ERROR",
            "GATEWAY_ERROR",
            "SCALED_DOWN",
            "DONE_BY_RUNNER",
            "ABORTED_BY_USER",
            "TERMINATED_BY_SERVER",
            "CONTAINER_EXITED_WITH_ERROR",
            "PORTS_BINDING_FAILED",
            "CREATING_CONTAINER_ERROR",
            "EXECUTOR_ERROR",
            "MAX_DURATION_EXCEEDED",
        ],
        affected_columns=[
            TableReference(
                table_schema="public", table_name="jobs", column_name="termination_reason"
            )
        ],
        enum_values_to_rename=[],
    )
    # ### end Alembic commands ###
