"""Add SecretModel

Revision ID: 644b8a114187
Revises: 5f1707c525d2
Create Date: 2025-06-30 11:00:04.326290

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "644b8a114187"
down_revision = "5f1707c525d2"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "secrets",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column(
            "project_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False
        ),
        sa.Column("created_at", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column("updated_at", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column("name", sa.String(length=200), nullable=False),
        sa.Column("value", dstack._internal.server.models.EncryptedString(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["projects.id"],
            name=op.f("fk_secrets_project_id_projects"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_secrets")),
        sa.UniqueConstraint("project_id", "name", name="uq_secrets_project_id_name"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("secrets")
    # ### end Alembic commands ###
