"""Add InstanceModel.unreachable

Revision ID: b4d6ad60db08
Revises: 29826f417010
Create Date: 2024-05-30 09:55:43.842473

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "b4d6ad60db08"
down_revision = "29826f417010"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.add_column(sa.Column("unreachable", sa.Boolean(), nullable=True))

    op.execute(sa.sql.text("UPDATE instances SET unreachable = FALSE"))

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column("unreachable", nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.drop_column("unreachable")

    # ### end Alembic commands ###
