"""Store BackendType as string

Revision ID: bc8ca4a505c6
Revises: 98d1b92988bc
Create Date: 2025-03-10 14:49:06.837118

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "bc8ca4a505c6"
down_revision = "98d1b92988bc"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("backends", schema=None) as batch_op:
        batch_op.alter_column(
            "type",
            existing_type=postgresql.ENUM(
                "AWS",
                "AZURE",
                "CUDO",
                "DATACRUNCH",
                "DSTACK",
                "GCP",
                "KUBERNETES",
                "LAMBDA",
                "LOCAL",
                "REMOTE",
                "NEBIUS",
                "OCI",
                "RUNPOD",
                "TENSORDOCK",
                "VASTAI",
                "VULTR",
                name="backendtype",
            ),
            type_=sa.String(length=100),
            existing_nullable=False,
        )

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "backend",
            existing_type=postgresql.ENUM(
                "AWS",
                "AZURE",
                "CUDO",
                "DATACRUNCH",
                "DSTACK",
                "GCP",
                "KUBERNETES",
                "LAMBDA",
                "LOCAL",
                "REMOTE",
                "NEBIUS",
                "OCI",
                "RUNPOD",
                "TENSORDOCK",
                "VASTAI",
                "VULTR",
                name="backendtype",
            ),
            type_=sa.String(length=100),
            existing_nullable=True,
        )

    sa.Enum(
        "AWS",
        "AZURE",
        "CUDO",
        "DATACRUNCH",
        "DSTACK",
        "GCP",
        "KUBERNETES",
        "LAMBDA",
        "LOCAL",
        "REMOTE",
        "NEBIUS",
        "OCI",
        "RUNPOD",
        "TENSORDOCK",
        "VASTAI",
        "VULTR",
        name="backendtype",
    ).drop(op.get_bind())
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sa.Enum(
        "AWS",
        "AZURE",
        "CUDO",
        "DATACRUNCH",
        "DSTACK",
        "GCP",
        "KUBERNETES",
        "LAMBDA",
        "LOCAL",
        "REMOTE",
        "NEBIUS",
        "OCI",
        "RUNPOD",
        "TENSORDOCK",
        "VASTAI",
        "VULTR",
        name="backendtype",
    ).create(op.get_bind())
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "backend",
            existing_type=sa.String(length=100),
            type_=postgresql.ENUM(
                "AWS",
                "AZURE",
                "CUDO",
                "DATACRUNCH",
                "DSTACK",
                "GCP",
                "KUBERNETES",
                "LAMBDA",
                "LOCAL",
                "REMOTE",
                "NEBIUS",
                "OCI",
                "RUNPOD",
                "TENSORDOCK",
                "VASTAI",
                "VULTR",
                name="backendtype",
            ),
            existing_nullable=True,
            postgresql_using="backend::VARCHAR::backendtype",
        )

    with op.batch_alter_table("backends", schema=None) as batch_op:
        batch_op.alter_column(
            "type",
            existing_type=sa.String(length=100),
            type_=postgresql.ENUM(
                "AWS",
                "AZURE",
                "CUDO",
                "DATACRUNCH",
                "DSTACK",
                "GCP",
                "KUBERNETES",
                "LAMBDA",
                "LOCAL",
                "REMOTE",
                "NEBIUS",
                "OCI",
                "RUNPOD",
                "TENSORDOCK",
                "VASTAI",
                "VULTR",
                name="backendtype",
            ),
            existing_nullable=False,
            postgresql_using="type::VARCHAR::backendtype",
        )

    # ### end Alembic commands ###
