"""Add fields for async gateway creation

Revision ID: c154eece89da
Revises: 58aa5162dcc3
Create Date: 2024-05-16 14:18:29.044545

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c154eece89da"
down_revision = "58aa5162dcc3"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("gateway_computes", schema=None) as batch_op:
        batch_op.add_column(sa.Column("active", sa.Boolean(), nullable=True))

    gateway_status_enum = sa.Enum(
        "SUBMITTED", "PROVISIONING", "RUNNING", "FAILED", name="gatewaystatus"
    )
    gateway_status_enum.create(op.get_bind(), checkfirst=True)

    with op.batch_alter_table("gateways", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "status",
                gateway_status_enum,
                nullable=True,
            )
        )
        batch_op.add_column(sa.Column("status_message", sa.Text(), nullable=True))
        batch_op.add_column(sa.Column("last_processed_at", sa.DateTime(), nullable=True))

    op.execute(
        sa.sql.text("UPDATE gateway_computes SET active = NOT deleted WHERE active is NULL")
    )
    op.execute(sa.sql.text("UPDATE gateways SET status = 'RUNNING' WHERE status is NULL"))
    op.execute(
        sa.sql.text(
            "UPDATE gateways SET last_processed_at = created_at WHERE last_processed_at is NULL"
        )
    )
    with op.batch_alter_table("gateway_computes", schema=None) as batch_op:
        batch_op.alter_column("active", nullable=False)

    with op.batch_alter_table("gateways", schema=None) as batch_op:
        batch_op.alter_column("status", nullable=False)
        batch_op.alter_column("last_processed_at", nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("gateways", schema=None) as batch_op:
        batch_op.drop_column("last_processed_at")
        batch_op.drop_column("status_message")
        batch_op.drop_column("status")

    with op.batch_alter_table("gateway_computes", schema=None) as batch_op:
        batch_op.drop_column("active")

    gateway_status_enum = sa.Enum(
        "SUBMITTED", "PROVISIONING", "RUNNING", "FAILED", name="gatewaystatus"
    )
    gateway_status_enum.drop(op.get_bind(), checkfirst=True)

    # ### end Alembic commands ###
