"""Add JobMetricsPoint

Revision ID: c20626d03cfb
Revises: a7b46c073fa1
Create Date: 2024-10-14 11:26:08.776260

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "c20626d03cfb"
down_revision = "a7b46c073fa1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "job_metrics_points",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("job_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("timestamp_micro", sa.BigInteger(), nullable=False),
        sa.Column("cpu_usage_micro", sa.BigInteger(), nullable=False),
        sa.Column("memory_usage_bytes", sa.BigInteger(), nullable=False),
        sa.Column("memory_working_set_bytes", sa.BigInteger(), nullable=False),
        sa.Column("gpus_memory_usage_bytes", sa.Text(), nullable=False),
        sa.Column("gpus_util_percent", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["job_id"], ["jobs.id"], name=op.f("fk_job_metrics_points_job_id_jobs")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_job_metrics_points")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("job_metrics_points")
    # ### end Alembic commands ###
