"""Add instance termination retries

Revision ID: c48df7985d57
Revises: 065588ec72b8
Create Date: 2025-01-14 13:33:17.722284

"""

import sqlalchemy as sa
from alembic import op

from dstack._internal.server.models import NaiveDateTime

# revision identifiers, used by Alembic.
revision = "c48df7985d57"
down_revision = "065588ec72b8"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("first_termination_retry_at", NaiveDateTime(), nullable=True)
        )
        batch_op.add_column(sa.Column("last_termination_retry_at", NaiveDateTime(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.drop_column("last_termination_retry_at")
        batch_op.drop_column("first_termination_retry_at")

    # ### end Alembic commands ###
